/*
 * Decompiled with CFR 0.152.
 */
package biz.princeps.lib;

import biz.princeps.lib.TranslateableStrings;
import biz.princeps.lib.command.CommandManager;
import biz.princeps.lib.crossversion.CrossVersion;
import biz.princeps.lib.crossversion.Stuff;
import biz.princeps.lib.item.ItemManager;
import biz.princeps.lib.manager.ConfirmationManager;
import java.io.File;
import java.io.IOException;
import org.bukkit.configuration.InvalidConfigurationException;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.event.Listener;
import org.bukkit.plugin.java.JavaPlugin;

public class PrincepsLib
extends JavaPlugin
implements Listener {
    private static JavaPlugin INSTANCE;
    private static CrossVersion CROSS_VERSION;
    private static ItemManager ITEM_MANAGER;
    private static CommandManager COMMAND_MANAGER;
    private static ConfirmationManager CONFIRMATION_MANAGER;
    private static Stuff STUFF_MANAGER;
    private static TranslateableStrings TRANSLATEABLE_STRINGS;

    public static JavaPlugin getPluginInstance() {
        return INSTANCE;
    }

    public static void setPluginInstance(JavaPlugin plugin) {
        INSTANCE = plugin;
        CROSS_VERSION = new CrossVersion();
        ITEM_MANAGER = new ItemManager();
        COMMAND_MANAGER = new CommandManager();
        CONFIRMATION_MANAGER = new ConfirmationManager(plugin);
        STUFF_MANAGER = new Stuff(plugin);
        TRANSLATEABLE_STRINGS = new TranslateableStrings();
    }

    public static FileConfiguration prepareDatabaseFile() {
        File file = new File(PrincepsLib.getPluginInstance().getDataFolder(), "MySQL.yml");
        if (!file.exists()) {
            try {
                INSTANCE.getDataFolder().mkdirs();
                file.createNewFile();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        YamlConfiguration config = new YamlConfiguration();
        try {
            config.load(file);
        }
        catch (IOException | InvalidConfigurationException e) {
            e.printStackTrace();
        }
        config.addDefault("MySQL.Hostname", (Object)"localhost");
        config.addDefault("MySQL.Port", (Object)3306);
        config.addDefault("MySQL.Database", (Object)"minecraft");
        config.addDefault("MySQL.User", (Object)"root");
        config.addDefault("MySQL.Password", (Object)"passy");
        config.options().copyDefaults(true);
        try {
            config.save(file);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return config;
    }

    public static CrossVersion crossVersion() {
        return CROSS_VERSION;
    }

    public static ItemManager getItemManager() {
        return ITEM_MANAGER;
    }

    public static CommandManager getCommandManager() {
        return COMMAND_MANAGER;
    }

    public static ConfirmationManager getConfirmationManager() {
        return CONFIRMATION_MANAGER;
    }

    public static Stuff getStuffManager() {
        return STUFF_MANAGER;
    }

    public static TranslateableStrings getTranslateableStrings() {
        return TRANSLATEABLE_STRINGS;
    }

    public void onEnable() {
        PrincepsLib.setPluginInstance(this);
    }
}

