/*
 * Decompiled with CFR 0.152.
 */
package biz.princeps.landlord.util;

import biz.princeps.landlord.api.ILandLord;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scoreboard.DisplaySlot;
import org.bukkit.scoreboard.Objective;
import org.bukkit.scoreboard.Scoreboard;

public class SimpleScoreboard {
    private final ILandLord plugin;
    private final String title;
    private final List<String> scores;
    private final Player player;
    private Scoreboard scoreboard;
    private BukkitRunnable runnable;

    public SimpleScoreboard(ILandLord plugin, String title, Player p) {
        Objects.requireNonNull(p);
        this.plugin = plugin;
        this.scoreboard = plugin.getServer().getScoreboardManager().getNewScoreboard();
        this.title = title;
        this.scores = new ArrayList<String>();
        this.player = p;
    }

    public void add(String text) {
        Preconditions.checkArgument((text.length() < 48 ? 1 : 0) != 0, (Object)"text cannot be over 48 characters in length");
        this.add(text, this.scores.size());
    }

    public void add(String text, Integer score) {
        Preconditions.checkArgument((text.length() < 48 ? 1 : 0) != 0, (Object)"text cannot be over 48 characters in length");
        this.scores.add(score, text);
    }

    private String fixDuplicates(String text) {
        while (this.scores.contains(text)) {
            text = text + "\u00a7r";
        }
        if (text.length() > 48) {
            text = text.substring(0, 47);
        }
        return text;
    }

    private void build() {
        String s = this.title.length() > 16 ? this.title.substring(0, 15) : this.title;
        Objective obj = this.scoreboard.getObjective(s);
        if (obj == null) {
            obj = this.scoreboard.registerNewObjective(s, "dummy");
        }
        obj.setDisplayName(this.title);
        obj.setDisplaySlot(DisplaySlot.SIDEBAR);
        for (int i = 0; i < this.scores.size(); ++i) {
            obj.getScore(this.scores.get(this.scores.size() - 1 - i)).setScore(i);
        }
    }

    public void reset() {
        this.scores.clear();
        this.scoreboard = this.plugin.getServer().getScoreboardManager().getNewScoreboard();
        this.player.setScoreboard(this.scoreboard);
    }

    public Scoreboard getScoreboard() {
        return this.scoreboard;
    }

    public void send() {
        this.build();
        this.player.setScoreboard(this.scoreboard);
    }

    public void scheduleUpdate(Plugin plugin, final Runnable run, long delay, long timer) {
        this.runnable = new BukkitRunnable(){

            public void run() {
                run.run();
            }
        };
        this.runnable.runTaskTimer(plugin, delay, timer);
    }

    public void deactivate() {
        if (this.runnable != null) {
            this.runnable.cancel();
        }
        this.scoreboard = this.plugin.getServer().getScoreboardManager().getNewScoreboard();
        this.player.setScoreboard(this.scoreboard);
    }
}

