/*
 * Decompiled with CFR 0.152.
 */
package biz.princeps.landlord.util;

import biz.princeps.landlord.api.ILandLord;
import biz.princeps.landlord.api.ILangManager;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.List;
import java.util.regex.Pattern;
import org.bukkit.World;
import org.bukkit.block.BlockFace;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class JavaUtils {
    public static final BlockFace[] BLOCK_FACES = new BlockFace[]{BlockFace.SOUTH, BlockFace.WEST, BlockFace.NORTH, BlockFace.EAST};

    public static double round(double value, int places) {
        if (places < 0) {
            throw new IllegalArgumentException();
        }
        BigDecimal bd = BigDecimal.valueOf(value);
        bd = bd.setScale(places, RoundingMode.HALF_UP);
        return bd.doubleValue();
    }

    public static boolean isDisabledWorld(ILangManager lm, ILandLord plugin, Player player, boolean message) {
        return JavaUtils.isDisabledWorld(lm, plugin, player, player.getWorld(), message);
    }

    public static boolean isDisabledWorld(ILangManager lm, ILandLord plugin, Player player, World world, boolean message) {
        List stringList = plugin.getConfig().getStringList("disabled-worlds");
        for (String s : stringList) {
            if (!Pattern.compile(s).matcher(world.getName()).matches()) continue;
            if (message) {
                lm.sendMessage((CommandSender)player, lm.getString(player, "Disabled-World"));
            }
            return true;
        }
        return false;
    }

    public static BlockFace getBlockFace(float yaw) {
        return BLOCK_FACES[Math.round(yaw / 90.0f) & 3];
    }
}

