/*
 * Decompiled with CFR 0.152.
 */
package biz.princeps.landlord.regenerators;

import LandLord.landlord.paperlib.PaperLib;
import biz.princeps.landlord.api.ILandLord;
import biz.princeps.landlord.api.IOwnedLand;
import biz.princeps.landlord.api.IRegenerationManager;
import com.sk89q.worldedit.EditSession;
import com.sk89q.worldedit.WorldEdit;
import com.sk89q.worldedit.WorldEditException;
import com.sk89q.worldedit.bukkit.BukkitAdapter;
import com.sk89q.worldedit.extent.Extent;
import com.sk89q.worldedit.extent.clipboard.Clipboard;
import com.sk89q.worldedit.extent.clipboard.io.BuiltInClipboardFormat;
import com.sk89q.worldedit.extent.clipboard.io.ClipboardReader;
import com.sk89q.worldedit.function.operation.Operation;
import com.sk89q.worldedit.function.operation.Operations;
import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldedit.session.ClipboardHolder;
import com.sk89q.worldedit.world.World;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import org.bukkit.Chunk;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;

public class WGRegenerator
implements IRegenerationManager {
    private final ILandLord plugin;

    public WGRegenerator(ILandLord plugin) {
        this.plugin = plugin;
    }

    @Override
    public void regenerateChunk(org.bukkit.World world, int x, int z) {
        WorldEdit worldEdit = WorldEdit.getInstance();
        World weWorld = BukkitAdapter.adapt((org.bukkit.World)world);
        PaperLib.getChunkAtAsync(world, x, z).thenAccept(chunk -> {
            IOwnedLand land = this.plugin.getWGManager().getRegion((Chunk)chunk);
            String landName = land.getName();
            for (Entity entity : chunk.getEntities()) {
                if (entity.getType() != EntityType.PLAYER) continue;
                this.plugin.getServer().getPlayer(entity.getName()).setHealth(20.0);
            }
            Path path = this.plugin.getDataFolder().toPath().resolve("chunksaves").resolve(landName);
            if (Files.exists(path, new LinkOption[0])) {
                BuiltInClipboardFormat format = BuiltInClipboardFormat.SPONGE_SCHEMATIC;
                try (EditSession editSession = worldEdit.getEditSessionFactory().getEditSession(weWorld, -1);
                     ClipboardReader reader = format.getReader(Files.newInputStream(path, new OpenOption[0]));){
                    Clipboard clipboard = reader.read();
                    Operation operation = new ClipboardHolder(clipboard).createPaste((Extent)editSession).to(BlockVector3.at((int)(x << 4), (int)land.getMinY(), (int)(z << 4))).ignoreAirBlocks(false).build();
                    Operations.complete((Operation)operation);
                }
                catch (WorldEditException | IOException e) {
                    e.printStackTrace();
                }
            }
            for (Entity entity : chunk.getEntities()) {
                if (entity.getType() != EntityType.PLAYER) continue;
                Player p = this.plugin.getServer().getPlayer(entity.getName());
                p.setHealth(20.0);
                PaperLib.teleportAsync((Entity)p, world.getHighestBlockAt(p.getLocation().add(0.0, 3.0, 0.0)).getLocation());
            }
        });
    }
}

