/*
 * Decompiled with CFR 0.152.
 */
package biz.princeps.landlord.protection;

import biz.princeps.landlord.api.IOwnedLand;
import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.bukkit.World;

public class LandCache {
    private final Map<String, IOwnedLand> indexLandname = new HashMap<String, IOwnedLand>();
    private final Map<UUID, Set<IOwnedLand>> indexPlayer = new HashMap<UUID, Set<IOwnedLand>>();
    private final Map<World, Set<IOwnedLand>> indexWorld = new HashMap<World, Set<IOwnedLand>>();

    public void add(IOwnedLand land) {
        if (land == null) {
            throw new RuntimeException("Can't insert a null land!");
        }
        this.indexLandname.put(land.getName(), land);
        this.indexPlayer.computeIfAbsent(land.getOwner(), uuid -> Sets.newHashSet()).add(land);
        this.indexWorld.computeIfAbsent(land.getWorld(), uuid -> Sets.newHashSet()).add(land);
    }

    public IOwnedLand getLand(String name) {
        return this.indexLandname.get(name);
    }

    public Set<IOwnedLand> getLands(UUID uuid) {
        return this.indexPlayer.getOrDefault(uuid, Collections.emptySet());
    }

    public Set<IOwnedLand> getLands(World world) {
        return this.indexWorld.getOrDefault(world, Collections.emptySet());
    }

    public boolean contains(String name) {
        return this.indexLandname.containsKey(name);
    }

    public void remove(String name) {
        IOwnedLand toRemove = this.indexLandname.get(name);
        this.indexPlayer.get(toRemove.getOwner()).remove(toRemove);
        this.indexWorld.get(toRemove.getWorld()).remove(toRemove);
        this.indexLandname.remove(name);
    }
}

