/*
 * Decompiled with CFR 0.152.
 */
package biz.princeps.landlord.protection;

import biz.princeps.landlord.api.ClaimHeightDefinition;
import biz.princeps.landlord.api.ILandLord;
import biz.princeps.landlord.api.IOwnedLand;
import biz.princeps.landlord.api.IPlayer;
import biz.princeps.landlord.api.IWorldGuardManager;
import biz.princeps.landlord.api.tuple.Pair;
import biz.princeps.landlord.protection.LandCache;
import biz.princeps.lib.PrincepsLib;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.bukkit.ChatColor;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.OfflinePlayer;
import org.bukkit.Particle;
import org.bukkit.World;
import org.bukkit.entity.Player;

public abstract class AWorldGuardManager
implements IWorldGuardManager {
    protected final LandCache cache = new LandCache();
    protected final ILandLord plugin;

    public AWorldGuardManager(ILandLord plugin) {
        this.plugin = plugin;
    }

    @Override
    public World getWorld(String name) {
        String[] splitted = name.split("_");
        if (splitted.length < 3) {
            return null;
        }
        StringBuilder sb = new StringBuilder(splitted[0]);
        for (int i = 1; i < splitted.length - 2; ++i) {
            sb.append("_").append(splitted[i]);
        }
        return this.plugin.getServer().getWorld(sb.toString());
    }

    @Override
    public int getX(String name) {
        String[] splitted = name.split("_");
        if (splitted.length < 3) {
            return Integer.MIN_VALUE;
        }
        try {
            return Integer.parseInt(splitted[splitted.length - 2]);
        }
        catch (NumberFormatException e) {
            return Integer.MIN_VALUE;
        }
    }

    @Override
    public int getZ(String name) {
        String[] splitted = name.split("_");
        if (splitted.length < 3) {
            return Integer.MIN_VALUE;
        }
        try {
            return Integer.parseInt(splitted[splitted.length - 1]);
        }
        catch (NumberFormatException e) {
            return Integer.MIN_VALUE;
        }
    }

    @Override
    public boolean isLLRegion(String name) {
        World world = this.getWorld(name);
        if (world == null) {
            return false;
        }
        int x = this.getX(name);
        int z = this.getZ(name);
        return x != Integer.MIN_VALUE && z != Integer.MIN_VALUE;
    }

    @Override
    public Map<Chunk, IOwnedLand> getNearbyLands(Chunk chunk, int offsetX, int offsetZ) {
        HashMap<Chunk, IOwnedLand> lands = new HashMap<Chunk, IOwnedLand>();
        int xCoord = chunk.getX();
        int zCoord = chunk.getZ();
        for (int x = xCoord - offsetX; x <= xCoord + offsetX; ++x) {
            for (int z = zCoord - offsetZ; z <= zCoord + offsetZ; ++z) {
                Chunk chunkA = chunk.getWorld().getChunkAt(x, z);
                lands.put(chunkA, this.getRegion(chunkA));
            }
        }
        return lands;
    }

    @Override
    public Map<Chunk, IOwnedLand> getNearbyLands(Location loc, int offsetX, int offsetZ) {
        return this.getNearbyLands(loc.getChunk(), offsetX, offsetZ);
    }

    @Override
    public abstract void moveUp(World var1, int var2, int var3, int var4);

    @Override
    public Set<IOwnedLand> getRegions(UUID id) {
        HashSet<IOwnedLand> set = new HashSet<IOwnedLand>();
        OfflinePlayer op = this.plugin.getServer().getOfflinePlayer(id);
        if (op != null) {
            List worlds = this.plugin.getConfig().getStringList("disabled-worlds");
            for (World world : this.plugin.getServer().getWorlds()) {
                if (worlds.contains(world.getName())) continue;
                for (IOwnedLand region : this.getRegions(id, world)) {
                    if (!this.isLLRegion(region.getName())) continue;
                    set.add(region);
                }
            }
        }
        return set;
    }

    @Override
    public String getLandName(Chunk chunk) {
        return chunk.getWorld().getName().toLowerCase() + "_" + chunk.getX() + "_" + chunk.getZ();
    }

    @Override
    public String getLandName(Location location) {
        return location.getWorld().getName().toLowerCase() + "_" + (location.getBlockX() >> 4) + "_" + (location.getBlockZ() >> 4);
    }

    @Override
    public String formatLocation(Chunk chunk) {
        String configString = this.plugin.getConfig().getString("locationFormat");
        int x = (chunk.getX() << 4) + 8;
        int z = (chunk.getZ() << 4) + 8;
        configString = configString.replace("%world%", chunk.getWorld().getName());
        configString = configString.replace("%x%", x + "");
        configString = configString.replace("%z%", z + "");
        return ChatColor.translateAlternateColorCodes((char)'&', (String)configString);
    }

    @Override
    public void highlightLand(Chunk chunk, Player p, Particle particle, int amount, boolean everyone) {
        World world = chunk.getWorld();
        int x = chunk.getX() << 4;
        int z = chunk.getZ() << 4;
        int y = (int)p.getLocation().getY();
        if (!everyone) {
            Location location = new Location(world, (double)x, (double)y, (double)z);
            if (p.getLocation().distance(location) > 64.0) {
                return;
            }
        }
        HashSet<Location> edgeBlocks = new HashSet<Location>();
        for (int i = 0; i < 16; ++i) {
            for (int ii = -1; ii <= 10; ++ii) {
                edgeBlocks.add(new Location(world, (double)(x + i), (double)(y + ii), (double)(z + 15)));
                edgeBlocks.add(new Location(world, (double)(x + i), (double)(y + ii), (double)z));
                edgeBlocks.add(new Location(world, (double)x, (double)(y + ii), (double)(z + i)));
                edgeBlocks.add(new Location(world, (double)(x + 15), (double)(y + ii), (double)(z + i)));
            }
        }
        for (Location edgeBlock : edgeBlocks) {
            edgeBlock.setZ((double)edgeBlock.getBlockZ() + 0.5);
            edgeBlock.setX((double)edgeBlock.getBlockX() + 0.5);
            if (everyone) {
                PrincepsLib.getStuffManager().spawnPublicParticle(edgeBlock, particle, amount);
                continue;
            }
            PrincepsLib.getStuffManager().spawnPlayerParticle(p, edgeBlock, particle, amount);
        }
    }

    @Override
    public IOwnedLand[] getSurroundings(Location ploc) {
        if (ploc == null) {
            return new IOwnedLand[0];
        }
        return new IOwnedLand[]{this.getRegion(ploc), this.getRegion(ploc.clone().add(16.0, 0.0, 0.0)), this.getRegion(ploc.clone().add(0.0, 0.0, 16.0)), this.getRegion(ploc.clone().subtract(16.0, 0.0, 0.0)), this.getRegion(ploc.clone().subtract(0.0, 0.0, 16.0))};
    }

    @Override
    public IOwnedLand[] getSurroundings(Chunk chunk) {
        return this.getSurroundings(new Location(chunk.getWorld(), (double)(chunk.getX() << 4), 1.0, (double)(chunk.getZ() << 4)));
    }

    @Override
    public IOwnedLand[] getSurroundings(IOwnedLand land) {
        return this.getSurroundings(land.getChunk());
    }

    @Override
    public IOwnedLand[] getSurroundingsOwner(Location ploc, UUID owner) {
        IOwnedLand[] surroundings = this.getSurroundings(ploc);
        for (int i = 0; i < surroundings.length; ++i) {
            if (surroundings[i] == null || surroundings[i].isOwner(owner)) continue;
            surroundings[i] = null;
        }
        return surroundings;
    }

    @Override
    public IOwnedLand[] getSurroundingsOwner(Chunk chunk, UUID owner) {
        return this.getSurroundingsOwner(new Location(chunk.getWorld(), (double)(chunk.getX() << 4), 1.0, (double)(chunk.getZ() << 4)), owner);
    }

    @Override
    public IOwnedLand[] getSurroundingsOwner(IOwnedLand land, UUID owner) {
        return this.getSurroundingsOwner(land.getChunk(), owner);
    }

    @Override
    public IOwnedLand getRegion(Chunk chunk) {
        String name = this.getLandName(chunk);
        return this.getRegion(name);
    }

    @Override
    public IOwnedLand getRegion(Location loc) {
        String name = loc.getWorld().getName().toLowerCase().replace(" ", "_");
        name = name + "_";
        int x = loc.getBlockX() >> 4;
        name = name + x;
        name = name + "_";
        int z = loc.getBlockZ() >> 4;
        name = name + z;
        return this.getRegion(name);
    }

    @Override
    public int unclaim(Set<IOwnedLand> regions) {
        int count = regions.size();
        HashSet<UUID> owners = new HashSet<UUID>();
        for (IOwnedLand region : regions) {
            owners.add(region.getOwner());
        }
        for (UUID owner : owners) {
            this.plugin.getPlayerManager().getOffline(owner, lPlayer -> {
                for (IOwnedLand region : regions) {
                    if (!region.isOwner(owner) || lPlayer.getHome() == null || !region.contains(lPlayer.getHome())) continue;
                    lPlayer.setHome(null);
                    this.plugin.getPlayerManager().save((IPlayer)lPlayer, true);
                }
            });
        }
        for (IOwnedLand region : new HashSet<IOwnedLand>(regions)) {
            this.unclaim(region);
        }
        return count;
    }

    protected Pair<Integer, Integer> calcClaimHeightBoundaries(ClaimHeightDefinition boundaryMethod, World world, Chunk chunk, int minHeight, int maxHeight) {
        if (boundaryMethod == ClaimHeightDefinition.FULL) {
            return Pair.of(minHeight, maxHeight);
        }
        int bottomY = this.plugin.getConfigurationManager().getCustomizableInt(world, "ClaimHeight.bottomY", minHeight);
        int topY = this.plugin.getConfigurationManager().getCustomizableInt(world, "ClaimHeight.topY", maxHeight);
        if (boundaryMethod == ClaimHeightDefinition.FIXED) {
            return Pair.of(Math.max(minHeight, bottomY), Math.min(topY, maxHeight));
        }
        ArrayList<Integer> points = new ArrayList<Integer>();
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                points.add(world.getHighestBlockYAt((chunk.getX() << 4) + x, (chunk.getZ() << 4) + z));
            }
        }
        int center = boundaryMethod.getCenter(points);
        bottomY = center + bottomY;
        topY = center + topY;
        if (this.plugin.getConfigurationManager().getCustomizableBoolean(world, "ClaimHeight.appendOversize", false)) {
            if (topY > maxHeight) {
                bottomY -= topY - maxHeight;
                topY = maxHeight;
                if (bottomY < minHeight) {
                    bottomY = minHeight;
                }
            }
            if (bottomY < minHeight) {
                topY += Math.abs(bottomY);
                bottomY = minHeight;
                if (topY > maxHeight) {
                    topY = maxHeight;
                }
            }
        } else {
            bottomY = Math.max(bottomY, minHeight);
            topY = Math.min(topY, maxHeight);
        }
        return Pair.of(bottomY, topY);
    }
}

