/*
 * Decompiled with CFR 0.152.
 */
package biz.princeps.landlord.protection;

import biz.princeps.landlord.api.ILLFlag;
import biz.princeps.landlord.api.ILandLord;
import biz.princeps.landlord.api.IOwnedLand;
import biz.princeps.landlord.api.IWorldGuardManager;
import java.util.StringJoiner;
import java.util.UUID;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.Particle;
import org.bukkit.World;
import org.bukkit.entity.Player;

public abstract class AOwnedLand
implements IOwnedLand {
    private static final String NAMES_DELIMITER = ", ";
    protected final World world;
    protected final ILandLord plugin;
    protected final String name;
    protected final int chunkX;
    protected final int chunkZ;

    public AOwnedLand(ILandLord plugin, World world, String name) {
        this.plugin = plugin;
        this.world = world;
        this.name = name;
        IWorldGuardManager wg = plugin.getWGManager();
        this.chunkX = wg.getX(name);
        this.chunkZ = wg.getZ(name);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public int getChunkX() {
        return this.chunkX;
    }

    @Override
    public int getChunkZ() {
        return this.chunkZ;
    }

    @Override
    public void highlightLand(Chunk chunk, Player p, Particle pa) {
        this.highlightLand(chunk, p, pa, 1);
    }

    @Override
    public void highlightLand(Player p, Particle e) {
        this.highlightLand(p.getLocation().getChunk(), p, e, 1);
    }

    @Override
    public void highlightLand(Chunk chunk, Player p, Particle e, int amount) {
        this.plugin.getWGManager().highlightLand(chunk, p, e, amount, false);
    }

    @Override
    public Location getALocation() {
        IWorldGuardManager wg = this.plugin.getWGManager();
        World world = wg.getWorld(this.name);
        if (world == null) {
            return null;
        }
        return new Location(world, (double)(this.chunkX << 4), (double)(world.getHighestBlockYAt(this.chunkX << 4, this.chunkZ << 4) + 1), (double)(this.chunkZ << 4));
    }

    @Override
    public Chunk getChunk() {
        IWorldGuardManager wg = this.plugin.getWGManager();
        World w = wg.getWorld(this.name);
        if (w != null && this.chunkX != Integer.MIN_VALUE && this.chunkZ != Integer.MIN_VALUE) {
            return w.getChunkAt(this.chunkX, this.chunkZ);
        }
        return null;
    }

    @Override
    public boolean contains(Location loc) {
        return this.contains(loc.getBlockX(), loc.getBlockY(), loc.getBlockZ());
    }

    public abstract ILLFlag getFlag(String var1);

    protected String formatNames(Iterable<UUID> uuids) {
        StringJoiner stringJoiner = new StringJoiner(NAMES_DELIMITER);
        for (UUID uuid : uuids) {
            stringJoiner.add(this.plugin.getServer().getOfflinePlayer(uuid).getName());
        }
        return stringJoiner.toString();
    }
}

