/*
 * Decompiled with CFR 0.152.
 */
package biz.princeps.landlord.placeholderapi;

import biz.princeps.landlord.api.ILandLord;
import biz.princeps.landlord.api.IOwnedLand;
import biz.princeps.landlord.api.IPlayer;
import biz.princeps.landlord.api.IWorldGuardManager;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import me.clip.placeholderapi.expansion.PlaceholderExpansion;
import org.bukkit.entity.Player;

public class LLExpansion
extends PlaceholderExpansion {
    private final ILandLord plugin;
    private final IWorldGuardManager wg;
    private final Cache<String, String> cache;
    private final Cache<UUID, Integer> maxClaimPermissionCache;

    public LLExpansion(ILandLord plugin) {
        this.plugin = plugin;
        this.wg = plugin.getWGManager();
        this.cache = CacheBuilder.newBuilder().expireAfterWrite(500L, TimeUnit.MILLISECONDS).build();
        this.maxClaimPermissionCache = CacheBuilder.newBuilder().expireAfterWrite(10L, TimeUnit.SECONDS).build();
    }

    public String getIdentifier() {
        return "landlord";
    }

    public String getAuthor() {
        return String.valueOf(this.plugin.getDescription().getAuthors());
    }

    public String getVersion() {
        return this.plugin.getDescription().getVersion();
    }

    public boolean persist() {
        return true;
    }

    public boolean canRegister() {
        return true;
    }

    public String onPlaceholderRequest(Player player, String placeholder) {
        if (player == null) {
            return null;
        }
        try {
            return (String)this.cache.get((Object)(player.getName() + "_" + placeholder), () -> this.parsePlaceholder(player, placeholder));
        }
        catch (ExecutionException e) {
            this.plugin.getLogger().log(Level.SEVERE, "Could not parse placeholder: " + placeholder + " for " + player.getName() + "!", e);
            return null;
        }
    }

    private String parsePlaceholder(Player player, String placeholder) {
        switch (placeholder) {
            case "owned_lands": {
                return String.valueOf(this.wg.getRegionCount(player.getUniqueId()));
            }
            case "claims": {
                IPlayer iPlayer = this.plugin.getPlayerManager().get(player.getUniqueId());
                if (iPlayer == null) {
                    this.plugin.getLogger().warning("A placeholder is trying to load %landlord_claims% before async loading of the player has finished! Use FinishedLoadingPlayerEvent!");
                    return "NaN";
                }
                return String.valueOf(iPlayer.getClaims());
            }
            case "remaining_claims": {
                IPlayer iPlayer2 = this.plugin.getPlayerManager().get(player.getUniqueId());
                if (iPlayer2 == null) {
                    this.plugin.getLogger().warning("A placeholder is trying to load %landlord_remainingClaims% before async loading of the player has finished! Use FinishedLoadingPlayerEvent!");
                    return "NaN";
                }
                return String.valueOf(iPlayer2.getClaims() - this.wg.getRegionCount(player.getUniqueId()));
            }
            case "current_land_owner": {
                IOwnedLand region = this.wg.getRegion(player.getLocation());
                if (region != null && region.getOwner() != null) {
                    return region.getOwnersString();
                }
                return "\u2205";
            }
            case "current_land_members": {
                String members;
                IOwnedLand region2 = this.wg.getRegion(player.getLocation());
                if (region2 != null && !(members = region2.getMembersString()).isEmpty()) {
                    return members;
                }
                return "\u2205";
            }
            case "current_land_name": {
                return this.wg.getLandName(player.getLocation());
            }
            case "next_land_price": {
                return String.valueOf(this.plugin.getCostManager().calculateCost(player.getUniqueId()));
            }
            case "current_land_refund": {
                int regionCount = this.wg.getRegionCount(player.getUniqueId());
                return String.valueOf(this.plugin.getCostManager().calculateCost(regionCount - 1) * this.plugin.getConfig().getDouble("Payback"));
            }
            case "max_claim_permission": {
                return String.valueOf(this.getMaxClaimPermission(player));
            }
            case "remaining_free_lands": {
                int landCount = this.wg.getRegionCount(player.getUniqueId());
                int freeLands = this.plugin.getConfig().getInt("Freelands");
                if (landCount <= freeLands) {
                    return String.valueOf(Math.min(this.getMaxClaimPermission(player), freeLands) - landCount);
                }
                return "0";
            }
        }
        return "";
    }

    private int getMaxClaimPermission(Player player) {
        try {
            return (Integer)this.maxClaimPermissionCache.get((Object)player.getUniqueId(), () -> this.plugin.getPlayerManager().getMaxClaimPermission(player));
        }
        catch (ExecutionException e) {
            this.plugin.getLogger().log(Level.SEVERE, "Could not get maxClaimPermission for " + player.getName() + "!", e);
            return -1;
        }
    }
}

