/*
 * Decompiled with CFR 0.152.
 */
package biz.princeps.landlord.persistent;

import biz.princeps.landlord.api.IPlayer;
import biz.princeps.landlord.api.IStorage;
import biz.princeps.landlord.persistent.LPlayer;
import biz.princeps.lib.storage.Datastorage;
import biz.princeps.lib.util.SpigotUtil;
import biz.princeps.lib.util.TimeUtil;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.UUID;
import java.util.function.Consumer;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class SQLStorage
extends Datastorage
implements IStorage {
    private static final int CURRENT_VERSION = 4;

    public SQLStorage(Plugin plugin) {
        super(plugin, plugin.getConfig().getString("MySQL.Hostname"), plugin.getConfig().getString("MySQL.Port"), plugin.getConfig().getString("MySQL.User"), plugin.getConfig().getString("MySQL.Password"), plugin.getConfig().getString("MySQL.Database"));
        this.executeQuery("SELECT version FROM ll_version", this::handleUpgrade, new Object[0]);
    }

    private void handleUpgrade(ResultSet res) {
        try {
            res.next();
            boolean hasUpgraded = false;
            for (int localVersion = res.getInt("version"); localVersion < 4; ++localVersion) {
                this.executeUpgrade(localVersion);
                hasUpgraded = true;
            }
            if (hasUpgraded) {
                this.executeAsync("UPDATE version FROM ll_version SET version = ?", 4);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            this.plugin.getLogger().warning("Error while handling upgrade!\nError:" + e.getMessage());
        }
    }

    private void executeUpgrade(int localVersion) {
        switch (localVersion) {
            default: 
        }
    }

    @Override
    protected void setupDatabase() {
        this.execute("CREATE TABLE IF NOT EXISTS ll_players (uuid VARCHAR(36)       NOT NULL,name VARCHAR(16),claims INTEGER,home TEXT,lastseen VARCHAR(50),PRIMARY KEY(uuid));", new Object[0]);
        this.execute("CREATE TABLE IF NOT EXISTS ll_version(version TINYINT,PRIMARY KEY(version));", new Object[0]);
        this.execute("INSERT INTO ll_version (version) SELECT 4 FROM DUAL WHERE NOT EXISTS (SELECT * FROM ll_version)", new Object[0]);
    }

    @Override
    public void getPlayer(UUID id, Consumer<IPlayer> consumer) {
        this.plugin.getServer().getScheduler().runTaskAsynchronously(this.plugin, () -> consumer.accept(this.getPlayer(id)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IPlayer getPlayer(UUID id) {
        try (Datastorage.Triplet triplet = this.executeQuery("SELECT * FROM ll_players WHERE uuid = '" + id + "'", new Object[0]);){
            ResultSet res = triplet.getResultSet();
            if (!res.next()) {
                IPlayer iPlayer = null;
                return iPlayer;
            }
            LPlayer lPlayer = new LPlayer(UUID.fromString(res.getString("uuid")), res.getString("name"), res.getInt("claims"), SpigotUtil.exactlocationFromString(res.getString("home")), TimeUtil.stringToTime(res.getString("lastseen")));
            return lPlayer;
        }
        return null;
    }

    @Override
    public void savePlayer(IPlayer lp, boolean async) {
        final Runnable r = () -> this.execute("REPLACE INTO ll_players (uuid, name, claims, home, lastseen) VALUES ('" + lp.getUuid() + "', '" + lp.getName() + "', " + lp.getClaims() + ", '" + SpigotUtil.exactlocationToString(lp.getHome()) + "', '" + TimeUtil.timeToString(lp.getLastSeen()) + "')", new Object[0]);
        if (async) {
            new BukkitRunnable(){

                public void run() {
                    r.run();
                }
            }.runTaskAsynchronously(this.plugin);
        } else {
            r.run();
        }
    }
}

