/*
 * Decompiled with CFR 0.152.
 */
package biz.princeps.landlord.persistent;

import biz.princeps.landlord.api.IPlayer;
import biz.princeps.landlord.api.IStorage;
import biz.princeps.landlord.persistent.LPlayer;
import biz.princeps.lib.util.SpigotUtil;
import biz.princeps.lib.util.TimeUtil;
import java.io.File;
import java.io.IOException;
import java.util.UUID;
import java.util.function.Consumer;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.InvalidConfigurationException;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class FlatFileStorage
implements IStorage {
    private final Plugin plugin;
    private File customConfigFile;
    private FileConfiguration customConfig;

    public FlatFileStorage(Plugin plugin) {
        this.plugin = plugin;
    }

    public void init() {
        this.customConfigFile = new File(this.plugin.getDataFolder(), "storage.yml");
        if (!this.customConfigFile.exists()) {
            this.customConfigFile.getParentFile().mkdirs();
            try {
                this.customConfigFile.createNewFile();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        this.customConfig = new YamlConfiguration();
        try {
            this.customConfig.load(this.customConfigFile);
        }
        catch (IOException | InvalidConfigurationException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void getPlayer(UUID id, Consumer<IPlayer> consumer) {
        consumer.accept(this.getPlayer(id));
    }

    @Override
    public IPlayer getPlayer(UUID id) {
        ConfigurationSection sec = this.customConfig.getConfigurationSection(id.toString());
        if (sec == null) {
            return null;
        }
        return new LPlayer(id, this.plugin.getServer().getOfflinePlayer(id).getName(), sec.getInt("claims"), SpigotUtil.exactlocationFromString(sec.getString("home")), TimeUtil.stringToTime(sec.getString("lastlogin")));
    }

    @Override
    public void savePlayer(IPlayer p, boolean async) {
        ConfigurationSection sec = this.customConfig.createSection(p.getUuid().toString());
        sec.set("claims", (Object)p.getClaims());
        sec.set("home", (Object)SpigotUtil.exactlocationToString(p.getHome()));
        sec.set("lastlogin", (Object)TimeUtil.timeToString(p.getLastSeen()));
        if (async) {
            new BukkitRunnable(){

                public void run() {
                    FlatFileStorage.this.save();
                }
            }.runTaskAsynchronously(this.plugin);
        }
    }

    public synchronized void save() {
        try {
            this.customConfig.save(this.customConfigFile);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

