/*
 * Decompiled with CFR 0.152.
 */
package biz.princeps.landlord.multi;

import biz.princeps.landlord.api.AMultiTask;
import biz.princeps.landlord.api.ILandLord;
import biz.princeps.landlord.api.ILangManager;
import biz.princeps.landlord.api.IOwnedLand;
import biz.princeps.landlord.api.IPlayer;
import biz.princeps.landlord.api.IWorldGuardManager;
import biz.princeps.landlord.api.ManageMode;
import biz.princeps.landlord.api.Options;
import biz.princeps.landlord.api.events.LandUnclaimEvent;
import java.util.Collection;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class MultiUnclaimTask
extends AMultiTask<IOwnedLand> {
    private final IWorldGuardManager wgManager;
    private final ILangManager lgManager;
    private final Player player;
    private final IPlayer lPlayer;
    private final int freeLands;
    private final int unclaimedLands;
    private final World world;
    private final ManageMode manageMode;
    private double totalPayBack;

    public MultiUnclaimTask(ILandLord plugin, Player player, Collection<IOwnedLand> operations, World world, ManageMode manageMode) {
        super(plugin, operations);
        this.wgManager = plugin.getWGManager();
        this.lgManager = plugin.getLangManager();
        this.player = player;
        this.lPlayer = plugin.getPlayerManager().get(player.getUniqueId());
        this.freeLands = plugin.getConfig().getInt("Freelands");
        this.unclaimedLands = operations.size();
        this.world = world;
        this.manageMode = manageMode;
        this.totalPayBack = 0.0;
    }

    @Override
    public boolean process(IOwnedLand ownedLand) {
        LandUnclaimEvent event = new LandUnclaimEvent(this.player, ownedLand);
        this.plugin.getServer().getPluginManager().callEvent((Event)event);
        if (!event.isCancelled()) {
            Location home;
            if (Options.isVaultEnabled()) {
                double payback;
                int regionCount = this.wgManager.getRegionCount(this.player.getUniqueId());
                if (regionCount <= this.freeLands) {
                    payback = 0.0;
                } else {
                    payback = this.plugin.getCostManager().calculateCost(regionCount - 1) * this.plugin.getConfig().getDouble("Payback");
                    if (payback > 0.0) {
                        this.plugin.getVaultManager().give(this.player, payback);
                    }
                }
                this.totalPayBack += payback;
            }
            Location location = ownedLand.getALocation();
            this.wgManager.unclaim(ownedLand.getWorld(), ownedLand.getName());
            if (this.plugin.getConfig().getBoolean("CommandSettings.Unclaim.regenerate", false)) {
                this.plugin.getRegenerationManager().regenerateChunk(location);
            }
            if (this.lPlayer != null && (home = this.lPlayer.getHome()) != null && ownedLand.contains(home.getBlockX(), home.getBlockY(), home.getBlockZ())) {
                this.lgManager.sendMessage((CommandSender)this.player, this.lgManager.getString(this.player, "Commands.SetHome.removed"));
                this.plugin.getPlayerManager().get(ownedLand.getOwner()).setHome(null);
            }
        }
        return true;
    }

    @Override
    public boolean canContinueProcessing() {
        return this.player.isOnline();
    }

    @Override
    public void complete() {
        switch (this.manageMode) {
            case MULTI: {
                this.lgManager.sendMessage((CommandSender)this.player, this.lgManager.getString(this.player, "Commands.MultiUnclaim.success").replace("%amount%", "" + this.unclaimedLands).replace("%money%", Options.isVaultEnabled() ? this.plugin.getVaultManager().format(this.totalPayBack) : "-eco disabled-"));
                break;
            }
            case ALL: {
                this.lgManager.sendMessage((CommandSender)this.player, this.lgManager.getString(this.player, "Commands.UnclaimAll.success").replace("%amount%", "" + this.unclaimedLands).replace("%world%", this.world.getName()).replace("%money%", Options.isVaultEnabled() ? this.plugin.getVaultManager().format(this.totalPayBack) : "-eco disabled-"));
            }
        }
        new BukkitRunnable(){

            public void run() {
                MultiUnclaimTask.this.plugin.getMapManager().updateAll();
            }
        }.runTask((Plugin)this.plugin);
    }
}

