/*
 * Decompiled with CFR 0.152.
 */
package biz.princeps.landlord.multi;

import biz.princeps.landlord.api.ILandLord;
import biz.princeps.landlord.api.IMultiTask;
import biz.princeps.landlord.api.IMultiTaskManager;
import java.util.ArrayDeque;
import java.util.Deque;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class MultiTaskManager
implements IMultiTaskManager {
    private final ILandLord plugin;
    private final Deque<IMultiTask<?>> queue;

    public MultiTaskManager(ILandLord plugin) {
        this.plugin = plugin;
        this.queue = new ArrayDeque(64);
    }

    @Override
    public void initTask() {
        new BukkitRunnable(){

            public void run() {
                if (MultiTaskManager.this.queue.isEmpty()) {
                    return;
                }
                MultiTaskManager.this.processQueue(10);
            }
        }.runTaskTimer((Plugin)this.plugin, 0L, 1L);
    }

    @Override
    public void processQueue(int limit) {
        int operations = 0;
        while (operations < limit && !this.queue.isEmpty()) {
            IMultiTask<?> multiTask = this.queue.peek();
            if (multiTask.canContinueProcessing()) {
                operations += multiTask.processOperations(limit - operations);
                if (!multiTask.isCompleted()) continue;
                multiTask.complete();
                this.queue.remove();
                continue;
            }
            multiTask.clearQueue();
            this.queue.remove();
        }
    }

    @Override
    public void enqueueTask(final IMultiTask<?> multiTask) {
        if (this.plugin.getServer().isPrimaryThread()) {
            this.queue.add(multiTask);
        } else {
            new BukkitRunnable(){

                public void run() {
                    MultiTaskManager.this.enqueueTask(multiTask);
                }
            }.runTask((Plugin)this.plugin);
        }
    }

    @Override
    public int clear() {
        int remainingTasks = this.queue.size();
        this.queue.clear();
        return remainingTasks;
    }
}

