/*
 * Decompiled with CFR 0.152.
 */
package biz.princeps.landlord.multi;

import biz.princeps.landlord.api.IOwnedLand;
import biz.princeps.landlord.api.IWorldGuardManager;
import biz.princeps.landlord.util.JavaUtils;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.BlockFace;

public enum MultiMode {
    CIRCULAR{

        @Override
        public Set<Location> getLandsLocations(int radius, Location center) {
            HashSet<Location> landsLocations = new HashSet<Location>();
            World world = center.getWorld();
            int xCenter = center.getBlockX() >> 4;
            int zCenter = center.getBlockZ() >> 4;
            double invRadiusX = 1.0 / (double)radius;
            double invRadiusZ = 1.0 / (double)radius;
            double nextXn = 0.0;
            block0: for (int x = 0; x <= radius; ++x) {
                double xn = nextXn;
                nextXn = (double)(x + 1) * invRadiusX;
                double nextZn = 0.0;
                for (int z = 0; z <= radius; ++z) {
                    double zn = nextZn;
                    nextZn = (double)(z + 1) * invRadiusZ;
                    double distanceSq = xn * xn + zn * zn;
                    if (distanceSq > 1.0) {
                        if (z != 0) continue block0;
                        break block0;
                    }
                    landsLocations.add(new Location(world, (double)(xCenter + x << 4), 0.0, (double)(zCenter + z << 4)));
                    landsLocations.add(new Location(world, (double)(xCenter - x << 4), 0.0, (double)(zCenter - z << 4)));
                    landsLocations.add(new Location(world, (double)(xCenter + x << 4), 0.0, (double)(zCenter - z << 4)));
                    landsLocations.add(new Location(world, (double)(xCenter - x << 4), 0.0, (double)(zCenter + z << 4)));
                }
            }
            return landsLocations;
        }
    }
    ,
    RECTANGULAR{

        @Override
        public Set<Location> getLandsLocations(int radius, Location center) {
            HashSet<Location> landsLocations = new HashSet<Location>();
            World world = center.getWorld();
            int xCenter = center.getBlockX() >> 4;
            int zCenter = center.getBlockZ() >> 4;
            for (int x = xCenter - radius; x <= xCenter + radius; ++x) {
                for (int z = zCenter - radius; z <= zCenter + radius; ++z) {
                    landsLocations.add(new Location(world, (double)(x << 4), 0.0, (double)(z << 4)));
                }
            }
            return landsLocations;
        }
    }
    ,
    LINEAR{

        @Override
        public Set<Location> getLandsLocations(int radius, Location center) {
            HashSet<Location> landsLocations = new HashSet<Location>();
            World world = center.getWorld();
            int xCenter = center.getBlockX() >> 4;
            int zCenter = center.getBlockZ() >> 4;
            BlockFace blockFace = JavaUtils.getBlockFace(center.getYaw());
            switch (blockFace) {
                case NORTH: {
                    for (int z = zCenter; z >= zCenter - radius; --z) {
                        landsLocations.add(new Location(world, (double)(xCenter << 4), 0.0, (double)(z << 4)));
                    }
                    break;
                }
                case EAST: {
                    for (int x = xCenter; x <= xCenter + radius; ++x) {
                        landsLocations.add(new Location(world, (double)(x << 4), 0.0, (double)(zCenter << 4)));
                    }
                    break;
                }
                case WEST: {
                    for (int x = xCenter; x >= xCenter - radius; --x) {
                        landsLocations.add(new Location(world, (double)(x << 4), 0.0, (double)(zCenter << 4)));
                    }
                    break;
                }
                case SOUTH: {
                    for (int z = zCenter; z <= zCenter + radius; ++z) {
                        landsLocations.add(new Location(world, (double)(xCenter << 4), 0.0, (double)(z << 4)));
                    }
                    break;
                }
            }
            return landsLocations;
        }
    };


    public abstract Set<Location> getLandsLocations(int var1, Location var2);

    public Set<Chunk> getFreeLands(int radius, Location center, IWorldGuardManager worldGuardManager) {
        HashSet<Chunk> chunks = new HashSet<Chunk>();
        for (Location landLocation : this.getLandsLocations(radius, center)) {
            IOwnedLand land = worldGuardManager.getRegion(landLocation);
            if (land != null) continue;
            chunks.add(landLocation.getChunk());
        }
        return chunks;
    }

    public Set<IOwnedLand> getLandsOf(int radius, Location center, UUID uuid, IWorldGuardManager worldGuardManager) {
        HashSet<IOwnedLand> lands = new HashSet<IOwnedLand>();
        for (Location landLocation : this.getLandsLocations(radius, center)) {
            IOwnedLand land = worldGuardManager.getRegion(landLocation);
            if (land == null || !land.isOwner(uuid)) continue;
            lands.add(land);
        }
        return lands;
    }
}

