/*
 * Decompiled with CFR 0.152.
 */
package biz.princeps.landlord.multi;

import biz.princeps.landlord.api.AMultiTask;
import biz.princeps.landlord.api.ClearType;
import biz.princeps.landlord.api.ILandLord;
import biz.princeps.landlord.api.ILangManager;
import biz.princeps.landlord.api.IOwnedLand;
import biz.princeps.landlord.api.IPlayer;
import biz.princeps.landlord.api.IPlayerManager;
import biz.princeps.landlord.api.IWorldGuardManager;
import biz.princeps.landlord.api.events.LandClearEvent;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import org.bukkit.Location;
import org.bukkit.command.CommandSender;
import org.bukkit.event.Event;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class MultiClearTask
extends AMultiTask<IOwnedLand> {
    private final IWorldGuardManager wgManager;
    private final IPlayerManager playerManager;
    private final ILangManager lgManager;
    private final CommandSender commandSender;
    private final String targetName;
    private final int clearedLands;
    private final Set<UUID> clearedHomes;
    private final ClearType clearType;

    public MultiClearTask(ILandLord plugin, CommandSender commandSender, Collection<IOwnedLand> operations, String targetName, ClearType clearType) {
        super(plugin, operations);
        this.wgManager = plugin.getWGManager();
        this.playerManager = plugin.getPlayerManager();
        this.lgManager = plugin.getLangManager();
        this.commandSender = commandSender;
        this.targetName = targetName;
        this.clearedLands = operations.size();
        this.clearedHomes = new HashSet<UUID>();
        this.clearType = clearType;
    }

    @Override
    public boolean process(IOwnedLand ownedLand) {
        LandClearEvent event = new LandClearEvent(this.commandSender, ownedLand);
        this.plugin.getServer().getPluginManager().callEvent((Event)event);
        if (!event.isCancelled()) {
            UUID owner = ownedLand.getOwner();
            if (this.clearType == ClearType.WORLD && !this.clearedHomes.contains(owner)) {
                this.playerManager.getOffline(owner, lPlayer -> {
                    if (lPlayer == null) {
                        return;
                    }
                    Location home = lPlayer.getHome();
                    if (home != null && home.getWorld().getName().equals(this.targetName)) {
                        lPlayer.setHome(null);
                        this.clearedHomes.add(lPlayer.getUuid());
                        this.playerManager.save((IPlayer)lPlayer, true);
                    }
                });
            }
            this.wgManager.unclaim(ownedLand);
        }
        return true;
    }

    @Override
    public void complete() {
        switch (this.clearType) {
            case PLAYER: {
                this.plugin.getPlayerManager().getOffline(this.targetName, lPlayer -> {
                    if (lPlayer == null) {
                        return;
                    }
                    lPlayer.setHome(null);
                    this.plugin.getPlayerManager().save((IPlayer)lPlayer, true);
                });
                this.lgManager.sendMessage(this.commandSender, this.lgManager.getString("Commands.Clear.gui.clearplayer.success").replace("%count%", String.valueOf(this.clearedLands)).replace("%player%", this.targetName));
                break;
            }
            case WORLD: {
                this.lgManager.sendMessage(this.commandSender, this.lgManager.getString("Commands.Clear.gui.clearworld.success").replace("%count%", String.valueOf(this.clearedLands)).replace("%world%", this.targetName));
            }
        }
        new BukkitRunnable(){

            public void run() {
                MultiClearTask.this.plugin.getMapManager().updateAll();
            }
        }.runTask((Plugin)this.plugin);
    }
}

