/*
 * Decompiled with CFR 0.152.
 */
package biz.princeps.landlord.multi;

import biz.princeps.landlord.api.AMultiTask;
import biz.princeps.landlord.api.ILandLord;
import biz.princeps.landlord.api.ILangManager;
import biz.princeps.landlord.api.IWorldGuardManager;
import biz.princeps.landlord.api.events.LandClearInactiveEvent;
import java.util.Collection;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.event.Event;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class MultiClearInactiveTask
extends AMultiTask<OfflinePlayer> {
    private final IWorldGuardManager wgManager;
    private final ILangManager lgManager;
    private final CommandSender commandSender;
    private final long minInactiveDays;
    private final int clearedPlayers;
    private int clearedLands;

    public MultiClearInactiveTask(ILandLord plugin, CommandSender commandSender, Collection<OfflinePlayer> operations, int minInactiveDays) {
        super(plugin, operations);
        this.wgManager = plugin.getWGManager();
        this.lgManager = plugin.getLangManager();
        this.commandSender = commandSender;
        this.minInactiveDays = minInactiveDays;
        this.clearedPlayers = operations.size();
        this.clearedLands = 0;
    }

    @Override
    public boolean process(OfflinePlayer offlinePlayer) {
        LandClearInactiveEvent event = new LandClearInactiveEvent(this.commandSender, offlinePlayer);
        this.plugin.getServer().getPluginManager().callEvent((Event)event);
        if (!event.isCancelled()) {
            this.clearedLands += this.wgManager.unclaim(this.wgManager.getRegions(offlinePlayer.getUniqueId()));
        }
        return true;
    }

    @Override
    public void complete() {
        this.lgManager.sendMessage(this.commandSender, this.lgManager.getString("Commands.ClearInactive.success").replace("%players%", String.valueOf(this.clearedPlayers)).replace("%lands%", String.valueOf(this.clearedLands)).replace("%inactivity%", String.valueOf(this.minInactiveDays)));
        new BukkitRunnable(){

            public void run() {
                MultiClearInactiveTask.this.plugin.getMapManager().updateAll();
            }
        }.runTask((Plugin)this.plugin);
    }
}

