/*
 * Decompiled with CFR 0.152.
 */
package biz.princeps.landlord.manager.map;

import biz.princeps.landlord.api.ILandLord;
import biz.princeps.landlord.api.IMapManager;
import biz.princeps.landlord.manager.map.LandMap;
import biz.princeps.landlord.util.MapConstants;
import java.util.HashMap;
import java.util.UUID;
import org.bukkit.entity.Player;

public class MapManager
implements IMapManager {
    private final HashMap<UUID, LandMap> mapList;
    private final ILandLord plugin;
    private final MapConstants constants;

    public MapManager(ILandLord plugin) {
        this.plugin = plugin;
        this.mapList = new HashMap();
        this.constants = new MapConstants(plugin.getConfig());
    }

    @Override
    public void toggleMap(Player p) {
        if (this.hasMap(p.getUniqueId())) {
            this.removeMap(p);
        } else {
            this.addMap(p);
        }
    }

    @Override
    public void addMap(Player player) {
        if (!this.hasMap(player.getUniqueId())) {
            this.mapList.put(player.getUniqueId(), new LandMap(player, this.plugin, this.constants));
        }
    }

    @Override
    public void removeMap(Player player) {
        UUID pUUID = player.getUniqueId();
        if (this.hasMap(pUUID)) {
            LandMap curr = this.mapList.get(pUUID);
            curr.removeMap();
            this.mapList.remove(pUUID);
        }
    }

    @Override
    public void removeAllMaps() {
        for (UUID uuid : this.mapList.keySet()) {
            this.mapList.get(uuid).removeMap();
        }
        this.mapList.clear();
    }

    @Override
    public void updateAll() {
        for (UUID uuid : this.mapList.keySet()) {
            this.mapList.get(uuid).forceUpdate();
        }
    }

    @Override
    public void update(UUID playerUUID) {
        if (this.hasMap(playerUUID)) {
            this.mapList.get(playerUUID).forceUpdate();
        }
    }

    @Override
    public boolean hasMap(UUID playerUUID) {
        return this.mapList.containsKey(playerUUID);
    }
}

