/*
 * Decompiled with CFR 0.152.
 */
package biz.princeps.landlord.manager.map;

import biz.princeps.landlord.api.ILandLord;
import biz.princeps.landlord.api.IOwnedLand;
import biz.princeps.landlord.api.IWorldGuardManager;
import biz.princeps.landlord.util.MapConstants;
import biz.princeps.landlord.util.SimpleScoreboard;
import java.util.List;
import java.util.Map;
import org.bukkit.ChatColor;
import org.bukkit.Chunk;
import org.bukkit.entity.Player;

public class LandMap {
    private final ILandLord plugin;
    private final IWorldGuardManager wg;
    private final MapConstants cons;
    private final long refreshRate;
    private final String friendsSymbol;
    private final String ownSymbol;
    private final String foreignSymbol;
    private final String header;
    private final String yours;
    private final String friends;
    private final String others;
    private final Player mapViewer;
    private SimpleScoreboard scoreboard;
    private Chunk currChunk;
    private String currDir;
    private boolean update;

    LandMap(Player p, ILandLord plugin, MapConstants cons) {
        this.plugin = plugin;
        this.wg = plugin.getWGManager();
        this.ownSymbol = plugin.getConfig().getString("CommandSettings.Map.symbols.yours");
        this.friendsSymbol = plugin.getConfig().getString("CommandSettings.Map.symbols.friends");
        this.foreignSymbol = plugin.getConfig().getString("CommandSettings.Map.symbols.others");
        this.refreshRate = plugin.getConfig().getLong("Map.refreshRate", 10L);
        this.header = plugin.getLangManager().getRawString("Commands.LandMap.header");
        this.yours = plugin.getLangManager().getRawString("Commands.LandMap.yours");
        this.friends = plugin.getLangManager().getRawString("Commands.LandMap.friends");
        this.others = plugin.getLangManager().getRawString("Commands.LandMap.others");
        this.cons = cons;
        this.mapViewer = p;
        this.currChunk = p.getLocation().getChunk();
        this.currDir = LandMap.getPlayerDirection(p);
        this.displayMap(this.mapViewer);
    }

    private static String getPlayerDirection(Player playerSelf) {
        int i;
        float y = playerSelf.getLocation().getYaw();
        if (y < 0.0f) {
            y += 360.0f;
        }
        String dir = (i = (int)((double)((y %= 360.0f) + 8.0f) / 22.5)) == 0 ? "south" : (i == 1 ? "south southwest" : (i == 2 ? "southwest" : (i == 3 ? "west southwest" : (i == 4 ? "west" : (i == 5 ? "west northwest" : (i == 6 ? "northwest" : (i == 7 ? "north northwest" : (i == 8 ? "north" : (i == 9 ? "north northeast" : (i == 10 ? "northeast" : (i == 11 ? "east northeast" : (i == 12 ? "east" : (i == 13 ? "east southeast" : (i == 14 ? "southeast" : (i == 15 ? "south southeast" : "south")))))))))))))));
        return dir;
    }

    private String[][] getMapDir(Player p) {
        int i;
        float y = p.getLocation().getYaw();
        if (y < 0.0f) {
            y += 360.0f;
        }
        if ((i = (int)((double)((y %= 360.0f) + 8.0f) / 22.5)) == 0) {
            return this.cons.getS();
        }
        if (i == 1) {
            return this.cons.getSsw();
        }
        if (i == 2) {
            return this.cons.getSw();
        }
        if (i == 3) {
            return this.cons.getWsw();
        }
        if (i == 4) {
            return this.cons.getW();
        }
        if (i == 5) {
            return this.cons.getWnw();
        }
        if (i == 6) {
            return this.cons.getNw();
        }
        if (i == 7) {
            return this.cons.getNnw();
        }
        if (i == 8) {
            return this.cons.getN();
        }
        if (i == 9) {
            return this.cons.getNne();
        }
        if (i == 10) {
            return this.cons.getNe();
        }
        if (i == 11) {
            return this.cons.getEne();
        }
        if (i == 12) {
            return this.cons.getE();
        }
        if (i == 13) {
            return this.cons.getEse();
        }
        if (i == 14) {
            return this.cons.getSe();
        }
        if (i == 15) {
            return this.cons.getSse();
        }
        return this.cons.getS();
    }

    public Player getMapViewer() {
        return this.mapViewer;
    }

    void removeMap() {
        this.scoreboard.deactivate();
    }

    private SimpleScoreboard displayMap(final Player p) {
        this.scoreboard = new SimpleScoreboard(this.plugin, this.header, p);
        this.scoreboard.scheduleUpdate(this.plugin, new Runnable(){
            List<String> prev;

            @Override
            public void run() {
                String[] mapData;
                if (!LandMap.this.update && this.prev != null && LandMap.this.currChunk.equals((Object)LandMap.this.mapViewer.getLocation().getChunk()) && LandMap.this.currDir.equals(LandMap.getPlayerDirection(LandMap.this.mapViewer))) {
                    return;
                }
                LandMap.this.update = false;
                LandMap.this.updateMap();
                LandMap.this.scoreboard.reset();
                for (String aMapData : mapData = LandMap.this.buildMap(p)) {
                    LandMap.this.scoreboard.add(aMapData);
                }
                LandMap.this.scoreboard.send();
            }
        }, 0L, this.refreshRate);
        return this.scoreboard;
    }

    private void updateMap() {
        this.currChunk = this.mapViewer.getLocation().getChunk();
        this.currDir = LandMap.getPlayerDirection(this.mapViewer);
    }

    void forceUpdate() {
        this.update = true;
    }

    private String[] buildMap(Player p) {
        int radius = 3;
        String[][] mapBoard = this.getMapDir(p);
        String[] mapRows = new String[mapBoard.length + 3];
        Map<Chunk, IOwnedLand> nearby = this.wg.getNearbyLands(p.getLocation(), radius, radius);
        for (int z = 0; z < mapBoard.length; ++z) {
            StringBuilder row = new StringBuilder();
            for (int x = 0; x < mapBoard[z].length; ++x) {
                int xx = x - radius;
                int zz = z - radius;
                IOwnedLand land = nearby.get(p.getWorld().getChunkAt(xx + (p.getLocation().getBlockX() >> 4), zz + (p.getLocation().getBlockZ() >> 4)));
                String currSpot = mapBoard[z][x];
                currSpot = land != null ? (land.getOwner().equals(p.getUniqueId()) ? ChatColor.GREEN + currSpot : (land.isFriend(p.getUniqueId()) ? ChatColor.YELLOW + currSpot : ChatColor.RED + currSpot)) : (currSpot.equals(this.cons.getAr()) || currSpot.equals(this.cons.getMi()) ? ChatColor.RESET + currSpot : ChatColor.GRAY + currSpot);
                row.append(currSpot);
            }
            mapRows[z] = row.toString();
        }
        mapRows[mapRows.length - 3] = this.yours.length() <= 25 ? ChatColor.GREEN + this.ownSymbol + "- " + this.yours : ChatColor.GREEN + this.ownSymbol + "- " + this.yours.substring(0, 25);
        mapRows[mapRows.length - 2] = this.friends.length() <= 25 ? ChatColor.YELLOW + this.friendsSymbol + "- " + this.friends : ChatColor.YELLOW + this.friendsSymbol + "- " + this.friends.substring(0, 25);
        mapRows[mapRows.length - 1] = this.others.length() <= 25 ? ChatColor.RED + this.foreignSymbol + "- " + this.others : ChatColor.RED + this.foreignSymbol + "- " + this.others.substring(0, 25);
        return mapRows;
    }
}

