/*
 * Decompiled with CFR 0.152.
 */
package biz.princeps.landlord.manager;

import biz.princeps.landlord.OwnedLand;
import biz.princeps.landlord.api.ClaimHeightDefinition;
import biz.princeps.landlord.api.ILandLord;
import biz.princeps.landlord.api.IOwnedLand;
import biz.princeps.landlord.api.tuple.Pair;
import biz.princeps.landlord.protection.AWorldGuardManager;
import com.sk89q.worldedit.bukkit.BukkitAdapter;
import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldedit.regions.CuboidRegion;
import com.sk89q.worldedit.regions.RegionOperationException;
import com.sk89q.worldedit.world.World;
import com.sk89q.worldguard.LocalPlayer;
import com.sk89q.worldguard.WorldGuard;
import com.sk89q.worldguard.bukkit.WorldGuardPlugin;
import com.sk89q.worldguard.protection.ApplicableRegionSet;
import com.sk89q.worldguard.protection.flags.DoubleFlag;
import com.sk89q.worldguard.protection.flags.Flag;
import com.sk89q.worldguard.protection.flags.registry.FlagConflictException;
import com.sk89q.worldguard.protection.flags.registry.FlagRegistry;
import com.sk89q.worldguard.protection.managers.RegionManager;
import com.sk89q.worldguard.protection.regions.ProtectedCuboidRegion;
import com.sk89q.worldguard.protection.regions.ProtectedRegion;
import com.sk89q.worldguard.protection.regions.RegionContainer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.util.Vector;

public class WorldGuardManager
extends AWorldGuardManager {
    public static final DoubleFlag REGION_PRICE_FLAG = new DoubleFlag("region-price");
    private final WorldGuardPlugin wgPlugin;
    private final WorldGuard wg = WorldGuard.getInstance();

    public WorldGuardManager(ILandLord plugin, WorldGuardPlugin worldGuard) {
        super(plugin);
        this.wgPlugin = worldGuard;
    }

    public void initCache() {
        for (org.bukkit.World world : this.plugin.getServer().getWorlds()) {
            RegionManager manager = this.getRegionManager(world);
            for (ProtectedRegion value : manager.getRegions().values()) {
                if (!this.isLLRegion(value.getId())) continue;
                this.cache.add(OwnedLand.of(this.plugin, value));
            }
        }
    }

    public static void initFlags() {
        FlagRegistry registry = WorldGuard.getInstance().getFlagRegistry();
        try {
            registry.register((Flag)REGION_PRICE_FLAG);
        }
        catch (FlagConflictException flagConflictException) {
            // empty catch block
        }
    }

    @Override
    public IOwnedLand claim(Chunk chunk, UUID owner) {
        org.bukkit.World world = chunk.getWorld();
        int x = chunk.getX() << 4;
        int z = chunk.getZ() << 4;
        Pair<Integer, Integer> boundaries = this.calcClaimHeightBoundaries(chunk);
        Location down = new Location(world, (double)x, (double)boundaries.getLeft().intValue(), (double)z);
        Location upper = new Location(world, (double)(x + 15), (double)boundaries.getRight().intValue(), (double)(z + 15));
        BlockVector3 vec1 = this.locationToVec(down);
        BlockVector3 vec2 = this.locationToVec(upper);
        ProtectedCuboidRegion pr = new ProtectedCuboidRegion(this.getLandName(chunk), vec1, vec2);
        RegionManager manager = this.getRegionManager(chunk.getWorld());
        if (manager != null) {
            OwnedLand land = manager.hasRegion(pr.getId()) ? OwnedLand.of(this.plugin, (ProtectedRegion)pr) : OwnedLand.create(this.plugin, (ProtectedRegion)pr, owner);
            manager.addRegion((ProtectedRegion)pr);
            pr.getOwners().addPlayer(owner);
            this.cache.add(land);
            return land;
        }
        return null;
    }

    @Override
    public IOwnedLand getRegion(String name) {
        return this.cache.getLand(name);
    }

    @Override
    public Set<IOwnedLand> getRegions(org.bukkit.World world) {
        return this.cache.getLands(world);
    }

    @Override
    public Set<IOwnedLand> getRegions() {
        HashSet<IOwnedLand> lands = new HashSet<IOwnedLand>();
        for (org.bukkit.World world : this.plugin.getServer().getWorlds()) {
            lands.addAll(this.cache.getLands(world));
        }
        return lands;
    }

    @Override
    public Set<?> getAllWGRegions(org.bukkit.World world) {
        HashMap regions = new HashMap(this.getRegionManager(world).getRegions());
        for (String r : this.getRegionManager(world).getRegions().keySet()) {
            if (!this.isLLRegion(r)) continue;
            regions.remove(r);
        }
        return new HashSet(regions.values());
    }

    @Override
    public Set<?> getAllWGRegions() {
        HashSet set = new HashSet();
        for (org.bukkit.World world : this.plugin.getServer().getWorlds()) {
            Set<?> allWGRegions = this.getAllWGRegions(world);
            set.addAll(allWGRegions);
        }
        return set;
    }

    @Override
    public Set<IOwnedLand> getRegions(UUID id, org.bukkit.World world) {
        HashSet<IOwnedLand> lands = new HashSet<IOwnedLand>();
        for (IOwnedLand land : this.cache.getLands(id)) {
            if (land.getWorld() != world) continue;
            lands.add(land);
        }
        return lands;
    }

    @Override
    public Set<IOwnedLand> getRegions(UUID id) {
        return this.cache.getLands(id);
    }

    @Override
    public void unclaim(IOwnedLand land) {
        this.unclaim(land.getWorld(), land.getName());
    }

    @Override
    public void unclaim(final org.bukkit.World world, final String regionname) {
        this.cache.remove(regionname);
        new BukkitRunnable(){

            public void run() {
                WorldGuardManager.this.getRegionManager(world).removeRegion(regionname);
            }
        }.runTaskAsynchronously((Plugin)this.plugin);
    }

    @Override
    public boolean canClaim(Player player, Chunk currChunk) {
        RegionManager regionManager = this.getRegionManager(player.getWorld());
        if (regionManager == null) {
            return false;
        }
        org.bukkit.World world = currChunk.getWorld();
        int x = currChunk.getX() << 4;
        int z = currChunk.getZ() << 4;
        Pair<Integer, Integer> boundaries = this.calcClaimHeightBoundaries(currChunk);
        Vector v1 = new Location(world, (double)x, (double)boundaries.getLeft().intValue(), (double)z).toVector();
        Vector v2 = new Location(world, (double)(x + 15), (double)boundaries.getRight().intValue(), (double)(z + 15)).toVector();
        ProtectedCuboidRegion check = new ProtectedCuboidRegion("check", BlockVector3.at((double)v1.getX(), (double)v1.getY(), (double)v1.getZ()), BlockVector3.at((double)v2.getX(), (double)v2.getY(), (double)v2.getZ()));
        List intersects = check.getIntersectingRegions(new ArrayList(regionManager.getRegions().values()));
        for (ProtectedRegion intersect : intersects) {
            if (regionManager.getApplicableRegions(intersect).isMemberOfAll(this.wgPlugin.wrapPlayer(player))) continue;
            return false;
        }
        return true;
    }

    @Override
    public void moveUp(org.bukkit.World world, int chunkX, int chunkZ, int amount) {
        World weWorld = BukkitAdapter.adapt((org.bukkit.World)world);
        int x = chunkX << 4;
        int z = chunkZ << 4;
        Vector v1 = new Location(world, (double)x, (double)(weWorld.getMinY() + 3), (double)z).toVector();
        Vector v2 = new Location(world, (double)(x + 15), (double)weWorld.getMaxY(), (double)(z + 15)).toVector();
        BlockVector3 b1 = BlockVector3.at((double)v1.getX(), (double)v1.getY(), (double)v1.getZ());
        BlockVector3 b2 = BlockVector3.at((double)v2.getX(), (double)v2.getY(), (double)v2.getZ());
        CuboidRegion region = new CuboidRegion(weWorld, b1, b2);
        try {
            region.shift(BlockVector3.at((int)0, (int)amount, (int)0));
        }
        catch (RegionOperationException e) {
            e.printStackTrace();
        }
    }

    @Override
    public int getRegionCount(UUID id) {
        return this.cache.getLands(id).size();
    }

    @Override
    public int getRegionCount(UUID id, org.bukkit.World world) {
        return (int)this.cache.getLands(id).stream().filter(ownedLand -> ownedLand.getWorld().equals((Object)world)).count();
    }

    @Override
    public int getRegionCount(org.bukkit.World world) {
        return this.cache.getLands(world).size();
    }

    private RegionContainer getRegionContainer() {
        return this.wg.getPlatform().getRegionContainer();
    }

    private RegionManager getRegionManager(org.bukkit.World world) {
        World worldByName = BukkitAdapter.adapt((org.bukkit.World)world);
        RegionContainer regionContainer = this.getRegionContainer();
        return regionContainer.get(worldByName);
    }

    private BlockVector3 locationToVec(Location loc) {
        return BlockVector3.at((int)loc.getBlockX(), (int)loc.getBlockY(), (int)loc.getBlockZ());
    }

    @Override
    public boolean isAllowedInOverlap(Player p, Location loc) {
        LocalPlayer localPlayer = this.wgPlugin.wrapPlayer(p);
        ApplicableRegionSet applicableRegions = this.getRegionManager(loc.getWorld()).getApplicableRegions(this.locationToVec(loc));
        if (applicableRegions.getRegions().size() > 0) {
            for (ProtectedRegion protectedRegion : applicableRegions.getRegions()) {
                if (!protectedRegion.isMember(localPlayer) && !protectedRegion.isOwner(localPlayer)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public Pair<Integer, Integer> calcClaimHeightBoundaries(Chunk chunk) {
        org.bukkit.World world = chunk.getWorld();
        ClaimHeightDefinition boundaryMethod = ClaimHeightDefinition.parse(this.plugin.getConfigurationManager().getCustomizableString(world, "ClaimHeight.method", ClaimHeightDefinition.FULL.name()));
        if (boundaryMethod == null) {
            boundaryMethod = ClaimHeightDefinition.FULL;
        }
        World weWorld = BukkitAdapter.adapt((org.bukkit.World)world);
        int maxHeight = weWorld.getMaxY();
        int minHeight = weWorld.getMinY();
        return super.calcClaimHeightBoundaries(boundaryMethod, world, chunk, minHeight, maxHeight);
    }
}

