/*
 * Decompiled with CFR 0.152.
 */
package biz.princeps.landlord.manager;

import biz.princeps.landlord.api.ILandLord;
import biz.princeps.landlord.api.IVaultManager;
import biz.princeps.landlord.api.Options;
import java.util.UUID;
import net.milkbowl.vault.economy.Economy;
import org.bukkit.OfflinePlayer;
import org.bukkit.World;
import org.bukkit.entity.Player;

public class VaultManager
implements IVaultManager {
    private final ILandLord plugin;
    private final Economy economy;
    private final boolean defaultBalance;
    private final boolean playerWorldBased;
    private final String worldBalance;

    public VaultManager(ILandLord plugin, Economy economy) {
        this.plugin = plugin;
        this.economy = economy;
        String worldBalance = plugin.getConfig().getString("Economy.worldBalance");
        this.defaultBalance = worldBalance.equals("default");
        this.playerWorldBased = plugin.getConfig().getBoolean("Economy.playerWorldBased");
        this.worldBalance = worldBalance;
    }

    @Override
    public double getBalance(Player player) {
        return this.playerWorldBased ? this.economy.getBalance((OfflinePlayer)player, player.getWorld().getName()) : (this.defaultBalance ? this.economy.getBalance((OfflinePlayer)player) : this.economy.getBalance((OfflinePlayer)player, this.worldBalance));
    }

    @Override
    public boolean hasBalance(Player player, double amount) {
        return this.playerWorldBased ? this.economy.has((OfflinePlayer)player, player.getWorld().getName(), amount) : (this.defaultBalance ? this.economy.has((OfflinePlayer)player, amount) : this.economy.has((OfflinePlayer)player, this.worldBalance, amount));
    }

    @Override
    public void take(Player player, double amount) {
        if (this.playerWorldBased) {
            this.economy.withdrawPlayer((OfflinePlayer)player, player.getWorld().getName(), amount);
        } else if (this.defaultBalance) {
            this.economy.withdrawPlayer((OfflinePlayer)player, amount);
        } else {
            this.economy.withdrawPlayer((OfflinePlayer)player, this.worldBalance, amount);
        }
    }

    @Override
    public void give(UUID id, double amount, World world) {
        if (this.playerWorldBased) {
            this.economy.depositPlayer(this.plugin.getServer().getOfflinePlayer(id), world.getName(), amount);
        } else if (this.defaultBalance) {
            this.economy.depositPlayer(this.plugin.getServer().getOfflinePlayer(id), amount);
        } else {
            this.economy.depositPlayer(this.plugin.getServer().getOfflinePlayer(id), this.worldBalance, amount);
        }
    }

    @Override
    public void give(Player player, double amount) {
        if (this.playerWorldBased) {
            this.economy.depositPlayer((OfflinePlayer)player, player.getWorld().getName(), amount);
        } else if (this.defaultBalance) {
            this.economy.depositPlayer((OfflinePlayer)player, amount);
        } else {
            this.economy.depositPlayer((OfflinePlayer)player, this.worldBalance, amount);
        }
    }

    @Override
    public String format(double money) {
        return Options.isVaultEnabled() ? this.economy.format(money) : "-1";
    }
}

