/*
 * Decompiled with CFR 0.152.
 */
package biz.princeps.landlord.manager;

import biz.princeps.landlord.api.ILandLord;
import biz.princeps.landlord.api.ILangManager;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import me.clip.placeholderapi.PlaceholderAPI;
import net.md_5.bungee.api.ChatColor;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.InvalidConfigurationException;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;

public class LangManager
implements ILangManager {
    private final ILandLord plugin;
    private final String filename;
    private final boolean parsePlaceholders;
    private FileConfiguration msg;

    public LangManager(ILandLord plugin, String lang) {
        this.plugin = plugin;
        this.filename = "messages/" + lang + ".yml";
        this.reload();
        plugin.getConfigurationManager().handleConfigUpdate(plugin.getDataFolder() + "/" + this.filename, "/" + this.filename);
        this.reload();
        this.parsePlaceholders = plugin.getServer().getPluginManager().isPluginEnabled("PlaceholderAPI");
    }

    @Override
    public void reload() {
        File f = new File(this.plugin.getDataFolder(), this.filename);
        this.msg = new YamlConfiguration();
        try {
            File folder = new File(this.plugin.getDataFolder(), "messages");
            if (!folder.exists()) {
                folder.mkdir();
            }
            if (!f.exists()) {
                this.plugin.saveResource(this.filename, false);
            }
            this.msg.load(f);
        }
        catch (IOException | InvalidConfigurationException e) {
            e.printStackTrace();
        }
    }

    @Override
    public String getString(String path) {
        return this.getString(null, path);
    }

    @Override
    public String getString(Player player, String path) {
        String message = this.msg.getString(path);
        if (message == null) {
            this.plugin.getLogger().warning("Your language file " + this.filename + " seems to miss string '" + path + "'");
            return "MISSING STRING";
        }
        return ChatColor.translateAlternateColorCodes((char)'&', (String)(this.getTag() + " " + (this.parsePlaceholders ? PlaceholderAPI.setPlaceholders((Player)player, (String)message) : message)));
    }

    @Override
    public String getTag() {
        return ChatColor.translateAlternateColorCodes((char)'&', (String)this.msg.getString("Tag"));
    }

    @Override
    public List<String> getStringList(String path) {
        List message = this.msg.getStringList(path);
        if (message == null) {
            this.plugin.getLogger().warning("Your language file " + this.filename + " seems to miss string '" + path + "'");
            return Lists.newArrayList();
        }
        ArrayList<String> finishedFormatting = new ArrayList<String>();
        for (String s : message) {
            finishedFormatting.add(ChatColor.translateAlternateColorCodes((char)'&', (String)s));
        }
        return finishedFormatting;
    }

    @Override
    public String getRawString(String path) {
        String message = this.msg.getString(path);
        if (message == null) {
            this.plugin.getLogger().warning("Your language file " + this.filename + " seems to miss string '" + path + "'");
            return "MISSING STRING";
        }
        return ChatColor.translateAlternateColorCodes((char)'&', (String)message);
    }

    @Override
    public void sendMessage(CommandSender player, String msg) {
        if (msg.isEmpty() || msg.contains("%null%")) {
            return;
        }
        if (msg.equals("MISSING STRING") && this.plugin.getConfig().getBoolean("CommandSettings.Main.enableMissingStringWarning")) {
            player.sendMessage("\u00a7cThe string you are looking for does not exist. Please check the log for further information!");
        } else {
            player.spigot().sendMessage(TextComponent.fromLegacyText((String)msg));
        }
    }
}

