/*
 * Decompiled with CFR 0.152.
 */
package biz.princeps.landlord.manager;

import biz.princeps.landlord.api.ILandLord;
import biz.princeps.landlord.api.IPlayer;
import biz.princeps.landlord.api.IPlayerManager;
import biz.princeps.landlord.api.IStorage;
import biz.princeps.landlord.api.Options;
import biz.princeps.landlord.persistent.FlatFileStorage;
import biz.princeps.landlord.persistent.SQLStorage;
import java.time.Duration;
import java.time.LocalDateTime;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.Consumer;
import org.bukkit.entity.Player;
import org.bukkit.permissions.PermissionAttachmentInfo;

public class LPlayerManager
implements IPlayerManager {
    private final Map<UUID, IPlayer> players = new HashMap<UUID, IPlayer>();
    private final ILandLord plugin;
    private final IStorage stor;

    public LPlayerManager(ILandLord plugin) {
        this.plugin = plugin;
        if (plugin.getConfig().getString("DatabaseType").equalsIgnoreCase("MySQL")) {
            this.stor = new SQLStorage(plugin);
        } else {
            this.stor = new FlatFileStorage(plugin);
            ((FlatFileStorage)this.stor).init();
        }
    }

    @Override
    public synchronized void add(IPlayer lPlayer) {
        this.players.put(lPlayer.getUuid(), lPlayer);
    }

    @Override
    public synchronized void save(IPlayer lp, boolean b) {
        this.stor.savePlayer(lp, b);
    }

    @Override
    public void remove(UUID id) {
        this.players.remove(id);
    }

    @Override
    public void saveAllOnlineSync() {
        for (IPlayer value : this.players.values()) {
            this.save(value, false);
        }
        if (this.stor instanceof FlatFileStorage) {
            ((FlatFileStorage)this.stor).save();
        }
    }

    @Override
    public boolean contains(String name) {
        for (IPlayer lPlayer : this.players.values()) {
            if (lPlayer.getName() == null || !lPlayer.getName().equals(name)) continue;
            return true;
        }
        return false;
    }

    @Override
    public IPlayer get(String name) {
        for (IPlayer lPlayer : this.players.values()) {
            if (lPlayer.getName() == null || !lPlayer.getName().equals(name)) continue;
            return lPlayer;
        }
        return null;
    }

    @Override
    public IPlayer get(UUID id) {
        return this.players.get(id);
    }

    @Override
    public void getOffline(UUID id, Consumer<IPlayer> consumer) {
        this.stor.getPlayer(id, consumer);
    }

    @Override
    public void getOffline(String name, Consumer<IPlayer> consumer) {
        this.getOffline(this.plugin.getServer().getOfflinePlayer(name).getUniqueId(), consumer);
    }

    @Override
    public boolean isInactive(LocalDateTime lastSeenDate) {
        if (!Options.enabled_inactiveBuyUp()) {
            return false;
        }
        if (lastSeenDate == null) {
            return false;
        }
        int days = this.plugin.getConfig().getInt("BuyUpInactive.timegate");
        return lastSeenDate.plusDays(days).isBefore(LocalDateTime.now());
    }

    @Override
    public void isInactive(UUID id, Consumer<Boolean> consumer) {
        this.getOffline(id, (IPlayer lp) -> {
            if (lp != null) {
                consumer.accept(this.isInactive(lp.getLastSeen()));
            } else {
                consumer.accept(false);
            }
        });
    }

    @Override
    public void getInactiveRemainingDays(UUID owner, Consumer<Integer> consumer) {
        long days = this.plugin.getConfig().getInt("BuyUpInactive.timegate");
        this.getOffline(owner, (IPlayer offline) -> {
            if (offline != null) {
                consumer.accept((int)(days - Duration.between(offline.getLastSeen(), LocalDateTime.now()).toDays()));
            } else {
                consumer.accept(-1);
            }
        });
    }

    @Override
    public boolean isInactiveSync(UUID id) {
        IPlayer lp = this.getOfflineSync(id);
        if (lp != null) {
            return this.isInactive(lp.getLastSeen());
        }
        return false;
    }

    @Override
    public int getInactiveRemainingDaysSync(UUID owner) {
        long days = this.plugin.getConfig().getInt("BuyUpInactive.timegate");
        IPlayer offline = this.getOfflineSync(owner);
        if (offline != null) {
            return (int)(days - Duration.between(offline.getLastSeen(), LocalDateTime.now()).toDays());
        }
        return -1;
    }

    @Override
    public int getInactiveRemainingDays(LocalDateTime date) {
        long days = this.plugin.getConfig().getInt("BuyUpInactive.timegate");
        return (int)(days - Duration.between(date, LocalDateTime.now()).toDays());
    }

    @Override
    public int getMaxClaimPermission(Player player) {
        if (!player.hasPermission("landlord.limit.override")) {
            int highestAllowedLandCount = -1;
            Set perms = player.getEffectivePermissions();
            for (PermissionAttachmentInfo perm : perms) {
                int value;
                String s;
                if (!perm.getValue() || !(s = perm.getPermission()).startsWith("landlord.limit.") || (value = Integer.parseInt(s.substring(s.lastIndexOf(46) + 1))) <= highestAllowedLandCount) continue;
                highestAllowedLandCount = value;
            }
            return highestAllowedLandCount;
        }
        return Integer.MAX_VALUE;
    }

    @Override
    public IPlayer getOfflineSync(UUID id) {
        return this.stor.getPlayer(id);
    }
}

