/*
 * Decompiled with CFR 0.152.
 */
package biz.princeps.landlord.manager;

import biz.princeps.landlord.api.IDelimitationManager;
import biz.princeps.landlord.api.ILandLord;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.bukkit.Chunk;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;

public class DelimitationManager
implements IDelimitationManager {
    private final ILandLord plugin;
    private final Map<BlockVector, Material> pattern;

    public DelimitationManager(ILandLord plugin) {
        this.plugin = plugin;
        this.pattern = this.getPattern();
    }

    private Map<BlockVector, Material> getPattern() {
        if (this.pattern != null) {
            return this.pattern;
        }
        List cfgString = this.plugin.getConfig().getStringList("CommandSettings.Claim.delimitation");
        HashMap<Character, Material> varToMaterial = new HashMap<Character, Material>();
        HashMap<BlockVector, Material> delimitPattern = new HashMap<BlockVector, Material>();
        int x = 0;
        for (String s : cfgString) {
            if (s.startsWith("define:")) {
                String a = s.split(":")[1].trim();
                char var = a.split("=")[0].charAt(0);
                Material mat = Material.getMaterial((String)a.split("=")[1]);
                if (mat == null) {
                    this.plugin.getLogger().warning("Invalid Material in delimitation!");
                    return null;
                }
                varToMaterial.put(Character.valueOf(var), mat);
                continue;
            }
            if (s.length() == 16) {
                for (int z = 0; z < 16; ++z) {
                    char varString = s.charAt(z);
                    Material material = (Material)varToMaterial.get(Character.valueOf(varString));
                    delimitPattern.put(new BlockVector(x, z), material);
                }
                ++x;
                continue;
            }
            this.plugin.getLogger().warning("Invalid line '" + s + "' detected!!");
            return null;
        }
        return delimitPattern;
    }

    @Override
    public void delimit(Player player, Chunk chunk) {
        if (this.pattern == null) {
            this.plugin.getLogger().warning("Delimitation failed, because there was an error in the config!");
            return;
        }
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                Material mat = this.pattern.get(new BlockVector(x, z));
                if (mat == null) continue;
                int highestY = chunk.getWorld().getHighestBlockYAt((chunk.getX() << 4) + x, (chunk.getZ() << 4) + z);
                if (highestY < 0) {
                    highestY = 0;
                }
                Block b = chunk.getBlock(x, highestY, z);
                while (b.getType() != Material.AIR && b.getType() != this.plugin.getMaterialsManager().getGrass() && b.getType() != this.plugin.getMaterialsManager().getLongGrass()) {
                    b = chunk.getBlock(x, ++highestY, z);
                }
                if (this.plugin.getConfig().getBoolean("CommandSettings.Claim.enablePhantomBlocks")) {
                    this.plugin.getUtilsManager().sendFakeBlockPacket(player, b.getLocation(), mat);
                    continue;
                }
                b.setType(mat);
            }
        }
    }

    public static class BlockVector {
        private final int x;
        private final int z;

        public BlockVector(int x, int z) {
            this.x = x;
            this.z = z;
        }

        public String toString() {
            return "BlockVector{x=" + this.x + ", z=" + this.z + '}';
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            BlockVector that = (BlockVector)o;
            return this.x == that.x && this.z == that.z;
        }

        public int hashCode() {
            return Objects.hash(this.x, this.z);
        }
    }
}

