/*
 * Decompiled with CFR 0.152.
 */
package biz.princeps.landlord.manager;

import biz.princeps.landlord.api.IConfigurationManager;
import biz.princeps.landlord.api.ILandLord;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import org.bukkit.World;
import org.bukkit.configuration.InvalidConfigurationException;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;

public class ConfigurationManager
implements IConfigurationManager {
    private static final String WORLDS_SECTION = "worlds";
    private final ILandLord plugin;
    private final FileConfiguration configuration;

    public ConfigurationManager(ILandLord plugin) {
        this.plugin = plugin;
        this.configuration = plugin.getConfig();
    }

    @Override
    public void handleConfigUpdate(String pathToExisting, String pathInJar) {
        block17: {
            if (pathInJar == null || pathToExisting == null) {
                return;
            }
            try (InputStream resourceAsStream = this.plugin.getClass().getResourceAsStream(pathInJar);){
                YamlConfiguration config = new YamlConfiguration();
                File existing = new File(pathToExisting);
                config.load(existing);
                int version = config.getInt("version");
                if (resourceAsStream == null) {
                    this.plugin.getLogger().warning("You are using an unknown translation. Please be aware, that LandLord will not add any new strings to your translation. If you would like to see your translation inside the plugin, please contact the author!");
                    return;
                }
                BufferedReader reader = new BufferedReader(new InputStreamReader(resourceAsStream));
                YamlConfiguration jarConfig = new YamlConfiguration();
                jarConfig.load((Reader)reader);
                int i = jarConfig.getInt("version");
                if (i <= version) break block17;
                try (InputStream a = this.plugin.getClass().getResourceAsStream(pathInJar);){
                    Files.copy(a, Paths.get(pathToExisting + ".v" + i, new String[0]), StandardCopyOption.REPLACE_EXISTING);
                }
                this.plugin.getLogger().warning(pathToExisting + " config file is not up-to-date! You are on version " + version + " and LandLord expects version " + i + "! Please be aware, LandLord may not work as expected, take a look at generated file.");
            }
            catch (IOException | InvalidConfigurationException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public String getCustomizableString(World world, String defaultPath, String defaultValue) {
        return this.configuration.getString("worlds." + world.getName() + "." + defaultPath, this.configuration.getString(defaultPath, defaultValue));
    }

    @Override
    public int getCustomizableInt(World world, String defaultPath, int defaultValue) {
        return this.configuration.getInt("worlds." + world.getName() + "." + defaultPath, this.configuration.getInt(defaultPath, defaultValue));
    }

    @Override
    public boolean getCustomizableBoolean(World world, String defaultPath, boolean defaultValue) {
        return this.configuration.getBoolean("worlds." + world.getName() + "." + defaultPath, this.configuration.getBoolean(defaultPath, defaultValue));
    }
}

