/*
 * Decompiled with CFR 0.152.
 */
package biz.princeps.landlord.listener;

import biz.princeps.landlord.api.ILandLord;
import biz.princeps.landlord.api.IOwnedLand;
import biz.princeps.landlord.api.IWorldGuardManager;
import biz.princeps.landlord.api.events.PlayerBrokeSecureWorldEvent;
import biz.princeps.landlord.listener.BasicListener;
import biz.princeps.landlord.listener.MessageDisplay;
import biz.princeps.landlord.util.JavaUtils;
import biz.princeps.lib.PrincepsLib;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Cancellable;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.player.PlayerBucketEmptyEvent;

public class SecureWorldListener
extends BasicListener {
    private final MessageDisplay display;
    private final Set<String> worlds;
    private final int treshold;
    private final IWorldGuardManager wg;

    public SecureWorldListener(ILandLord plugin) {
        super(plugin);
        this.worlds = new HashSet<String>(plugin.getConfig().getStringList("SecureWorld.worlds"));
        if (this.worlds.isEmpty()) {
            this.worlds.addAll(plugin.getServer().getWorlds().stream().map(World::getName).collect(Collectors.toSet()));
        }
        this.treshold = plugin.getConfig().getInt("SecureWorld.threshold");
        this.wg = plugin.getWGManager();
        this.display = MessageDisplay.valueOf(plugin.getConfig().getString("SecureWorld.displayWarning"));
    }

    @EventHandler
    public void onBreak(BlockBreakEvent e) {
        Player p = e.getPlayer();
        IOwnedLand land = this.wg.getRegion(e.getBlock().getLocation());
        if (land == null) {
            PlayerBrokeSecureWorldEvent event = new PlayerBrokeSecureWorldEvent(p, e.getBlock(), (Cancellable)e);
            this.plugin.getServer().getPluginManager().callEvent((Event)event);
        }
    }

    @EventHandler
    public void onPlace(BlockPlaceEvent e) {
        Player p = e.getPlayer();
        IOwnedLand land = this.wg.getRegion(e.getBlock().getLocation());
        if (land == null) {
            PlayerBrokeSecureWorldEvent event = new PlayerBrokeSecureWorldEvent(p, e.getBlockPlaced(), (Cancellable)e);
            this.plugin.getServer().getPluginManager().callEvent((Event)event);
        }
    }

    @EventHandler
    public void onBucketEmpty(PlayerBucketEmptyEvent e) {
        Player p = e.getPlayer();
        IOwnedLand land = this.wg.getRegion(e.getBlockClicked().getLocation());
        if (land == null) {
            PlayerBrokeSecureWorldEvent event = new PlayerBrokeSecureWorldEvent(p, e.getBlockClicked(), (Cancellable)e);
            this.plugin.getServer().getPluginManager().callEvent((Event)event);
        }
    }

    @EventHandler
    public void onThresholdEvent(PlayerBrokeSecureWorldEvent e) {
        IOwnedLand land = this.wg.getRegion(e.getBlock().getLocation());
        if (!e.isCancelled()) {
            this.handleLand(e.getPlayer(), e.getBlock().getLocation(), land, e.getCancellable());
        }
    }

    private void handleLand(Player p, Location loc, IOwnedLand land, Cancellable e) {
        int landcount;
        if (p.isOp() || p.hasPermission("landlord.admin.bypass")) {
            return;
        }
        if (JavaUtils.isDisabledWorld(this.plugin.getLangManager(), this.plugin, p, loc.getWorld(), false)) {
            return;
        }
        if (this.wg.isAllowedInOverlap(p, loc)) {
            return;
        }
        if (land != null) {
            return;
        }
        if (!this.worlds.contains(loc.getWorld().getName())) {
            return;
        }
        int n = landcount = this.plugin.getConfig().getBoolean("SecureWord.perWorld") ? this.wg.getRegionCount(p.getUniqueId(), loc.getWorld()) : this.wg.getRegionCount(p.getUniqueId());
        if (landcount < this.treshold) {
            String rawString = this.plugin.getLangManager().getRawString("Alerts.tresholdNotReached").replace("%x%", this.treshold + "");
            if (this.display == MessageDisplay.ActionBar) {
                PrincepsLib.getStuffManager().sendActionBar(p, rawString);
            } else if (this.display == MessageDisplay.Chat) {
                this.plugin.getLangManager().sendMessage((CommandSender)p, this.plugin.getLangManager().getString("Alerts.tresholdNotReached").replace("%x%", this.treshold + ""));
            } else if (this.display == MessageDisplay.Title) {
                p.sendTitle(rawString, null, 10, 70, 20);
            }
            e.setCancelled(true);
        }
    }
}

