/*
 * Decompiled with CFR 0.152.
 */
package biz.princeps.landlord.listener;

import biz.princeps.landlord.api.ILandLord;
import biz.princeps.landlord.api.IOwnedLand;
import biz.princeps.landlord.api.IWorldGuardManager;
import biz.princeps.landlord.listener.BasicListener;
import com.sk89q.worldguard.bukkit.event.DelegateEvent;
import com.sk89q.worldguard.bukkit.event.block.BreakBlockEvent;
import com.sk89q.worldguard.bukkit.event.block.PlaceBlockEvent;
import com.sk89q.worldguard.bukkit.util.Materials;
import java.util.HashSet;
import java.util.List;
import java.util.UUID;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;

public class PistonOverwriter
extends BasicListener {
    private final IWorldGuardManager wg;

    public PistonOverwriter(ILandLord plugin) {
        super(plugin);
        this.wg = plugin.getWGManager();
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onPlaceBlock(PlaceBlockEvent event) {
        Block block = event.getCause().getFirstBlock();
        this.handleEvent((DelegateEvent)event, block, event.getBlocks());
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onBreakBlock(BreakBlockEvent event) {
        Block block = event.getCause().getFirstBlock();
        this.handleEvent((DelegateEvent)event, block, event.getBlocks());
    }

    private void handleEvent(DelegateEvent event, Block block, List<Block> blocks) {
        if (block == null) {
            return;
        }
        if ((Materials.isPistonBlock((Material)block.getType()) || block.getType() == Material.MOVING_PISTON) && this.sameOwner(block, blocks)) {
            event.setAllowed(true);
        }
    }

    private boolean sameOwner(Block origin, List<Block> blocks) {
        if (origin == null) {
            return false;
        }
        if (this.wg.getRegion(origin.getLocation()) == null) {
            return false;
        }
        HashSet<IOwnedLand> lands = new HashSet<IOwnedLand>();
        for (Block block : blocks) {
            lands.add(this.wg.getRegion(block.getLocation()));
        }
        UUID onlyOwner = this.wg.getRegion(origin.getLocation()).getOwner();
        for (IOwnedLand land : lands) {
            if (land == null) {
                return false;
            }
            if (onlyOwner.equals(land.getOwner())) continue;
            return false;
        }
        return true;
    }
}

