/*
 * Decompiled with CFR 0.152.
 */
package biz.princeps.landlord.listener;

import biz.princeps.landlord.api.ILandLord;
import biz.princeps.landlord.api.IMapManager;
import biz.princeps.landlord.listener.BasicListener;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.player.PlayerChangedWorldEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.player.PlayerRespawnEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class MapListener
extends BasicListener {
    private final IMapManager mapManager;

    public MapListener(ILandLord plugin) {
        super(plugin);
        this.mapManager = plugin.getMapManager();
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void playerLeave(PlayerQuitEvent event) {
        this.mapManager.removeMap(event.getPlayer());
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void playerWorldChange(PlayerChangedWorldEvent event) {
        this.mapManager.removeMap(event.getPlayer());
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void playerTeleportKeepMap(PlayerTeleportEvent event) {
        this.handleMapRefresh(event.getPlayer());
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void playerRespawn(PlayerRespawnEvent event) {
        this.handleMapRefresh(event.getPlayer());
    }

    private void handleMapRefresh(Player player) {
        new BukkitRunnable(){

            public void run() {
                MapListener.this.plugin.getMapManager().updateAll();
            }
        }.runTaskLater((Plugin)this.plugin, 15L);
    }
}

