/*
 * Decompiled with CFR 0.152.
 */
package biz.princeps.landlord.listener;

import biz.princeps.landlord.api.ILandLord;
import biz.princeps.landlord.api.events.LandChangeEvent;
import biz.princeps.landlord.listener.BasicListener;
import biz.princeps.landlord.listener.MessageDisplay;
import java.util.function.BiConsumer;
import net.md_5.bungee.api.ChatColor;
import net.md_5.bungee.api.ChatMessageType;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;

public class LandChangeListener
extends BasicListener {
    private final BiConsumer<String, Player> sendMessage;

    public LandChangeListener(ILandLord plugin) {
        super(plugin);
        MessageDisplay type = MessageDisplay.valueOf(plugin.getConfig().getString("LandMessage"));
        switch (type) {
            case ActionBar: {
                this.sendMessage = (message, player) -> player.spigot().sendMessage(ChatMessageType.ACTION_BAR, TextComponent.fromLegacyText((String)message));
                break;
            }
            case Chat: {
                this.sendMessage = (message, player) -> plugin.getLangManager().sendMessage((CommandSender)player, (String)message);
                break;
            }
            case Title: {
                this.sendMessage = (message, player) -> player.sendTitle(ChatColor.translateAlternateColorCodes((char)'&', (String)message), null, 10, 70, 20);
                break;
            }
            default: {
                this.sendMessage = (message, player) -> {};
            }
        }
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.MONITOR)
    public void onLandChange(LandChangeEvent event) {
        if (event.getNewLand() == null) {
            this.sendMessage.accept(event.getPreviousLand().getFarewellMessage(), event.getPlayer());
            return;
        }
        this.sendMessage.accept(event.getNewLand().getGreetMessage(), event.getPlayer());
    }
}

