/*
 * Decompiled with CFR 0.152.
 */
package biz.princeps.landlord.listener;

import biz.princeps.landlord.api.ILandLord;
import biz.princeps.landlord.api.IPlayer;
import biz.princeps.landlord.listener.BasicListener;
import biz.princeps.landlord.persistent.LPlayer;
import java.time.LocalDateTime;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.player.PlayerLoginEvent;
import org.bukkit.event.player.PlayerQuitEvent;

public class JoinListener
extends BasicListener {
    public JoinListener(ILandLord plugin) {
        super(plugin);
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onJoin(PlayerLoginEvent event) {
        Player p = event.getPlayer();
        this.plugin.getPlayerManager().getOffline(p.getUniqueId(), offline -> {
            if (offline == null) {
                offline = new LPlayer(p.getUniqueId(), p.getName(), 0, null, LocalDateTime.now());
            }
            this.plugin.getPlayerManager().add((IPlayer)offline);
            offline.setName(p.getName());
            offline.setLastSeen(LocalDateTime.now());
            this.plugin.getPlayerManager().save((IPlayer)offline, true);
        });
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onDisconnect(PlayerQuitEvent event) {
        Player p = event.getPlayer();
        IPlayer lp = this.plugin.getPlayerManager().get(p.getUniqueId());
        if (lp == null) {
            return;
        }
        lp.setLastSeen(LocalDateTime.now());
        this.plugin.getPlayerManager().save(lp, true);
        this.plugin.getPlayerManager().remove(p.getUniqueId());
    }
}

