/*
 * Decompiled with CFR 0.152.
 */
package biz.princeps.landlord.items;

import biz.princeps.landlord.api.ILandLord;
import biz.princeps.landlord.api.IOwnedLand;
import biz.princeps.lib.item.AbstractItem;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.block.Action;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class Maitem
extends AbstractItem {
    public static final String NAME = "maitem";
    private final ItemStack STACK;
    private final ArrayList<ItemClickAction> clickActions = new ArrayList();
    private final ILandLord plugin;

    public Maitem(ILandLord plugin) {
        super(NAME, new ItemStack(Material.valueOf((String)plugin.getConfig().getString("MaItem.item"))), true, false);
        this.plugin = plugin;
        this.STACK = this.getBukkitStack();
        this.initClickActions();
        this.setItemAppearance();
    }

    private void setItemAppearance() {
        List<String> lore = this.plugin.getLangManager().getStringList("MaItem.lore");
        String name = this.plugin.getLangManager().getRawString("MaItem.itemname");
        ItemMeta meta = this.STACK.getItemMeta();
        meta.setDisplayName(name);
        meta.setLore(lore);
        this.STACK.setItemMeta(meta);
    }

    private void initClickActions() {
        List stringList = this.plugin.getConfig().getStringList("MaItem.modes");
        for (String s : stringList) {
            String[] splitted = s.split(":");
            if (splitted.length != 3) {
                this.plugin.getLogger().warning("There was an error parsing your MaItem Config in line " + s);
                continue;
            }
            ClickedAtCondition clickedAtCondition = ClickedAtCondition.valueOf(splitted[0].toUpperCase());
            ClickCondition clickCondition = ClickCondition.valueOf(splitted[1].toUpperCase());
            ClickResult clickResult = ClickResult.valueOf(splitted[2].toUpperCase());
            this.clickActions.add(new ItemClickAction(clickedAtCondition, clickCondition, clickResult));
        }
    }

    @Override
    public void onClick(Action action, Player p, Location location) {
        if (location == null) {
            location = p.getLocation();
        }
        IOwnedLand landAtLoc = this.plugin.getWGManager().getRegion(location);
        switch (action) {
            case LEFT_CLICK_BLOCK: {
                for (ItemClickAction clickAction : this.clickActions) {
                    if (clickAction.getActivation() == ClickedAtCondition.LEFTCLICKBLOCK && !p.isSneaking()) {
                        this.checkForLandCondition(clickAction, p, landAtLoc, location);
                        continue;
                    }
                    if (clickAction.getActivation() != ClickedAtCondition.SHIFTLEFTCLICKBLOCK || !p.isSneaking()) continue;
                    this.checkForLandCondition(clickAction, p, landAtLoc, location);
                }
                break;
            }
            case RIGHT_CLICK_BLOCK: {
                for (ItemClickAction clickAction : this.clickActions) {
                    if (clickAction.getActivation() == ClickedAtCondition.RIGHTCLICKBLOCK && !p.isSneaking()) {
                        this.checkForLandCondition(clickAction, p, landAtLoc, location);
                        continue;
                    }
                    if (clickAction.getActivation() != ClickedAtCondition.SHIFTRIGHTCLICKBLOCK || !p.isSneaking()) continue;
                    this.checkForLandCondition(clickAction, p, landAtLoc, location);
                }
                break;
            }
            case LEFT_CLICK_AIR: {
                for (ItemClickAction clickAction : this.clickActions) {
                    if (clickAction.getActivation() == ClickedAtCondition.LEFTCLICKAIR && !p.isSneaking()) {
                        this.checkForLandCondition(clickAction, p, landAtLoc, location);
                        continue;
                    }
                    if (clickAction.getActivation() != ClickedAtCondition.SHIFTLEFTCLICKAIR || !p.isSneaking()) continue;
                    this.checkForLandCondition(clickAction, p, landAtLoc, location);
                }
                break;
            }
            case RIGHT_CLICK_AIR: {
                for (ItemClickAction clickAction : this.clickActions) {
                    if (clickAction.getActivation() == ClickedAtCondition.RIGHTCLICKAIR && !p.isSneaking()) {
                        this.checkForLandCondition(clickAction, p, landAtLoc, location);
                        continue;
                    }
                    if (clickAction.getActivation() != ClickedAtCondition.SHIFTRIGHTCLICKAIR || !p.isSneaking()) continue;
                    this.checkForLandCondition(clickAction, p, landAtLoc, location);
                }
                break;
            }
        }
    }

    private void checkForLandCondition(ItemClickAction clickAction, Player p, IOwnedLand landAtLoc, Location loc) {
        switch (clickAction.getCondition()) {
            case OWNLAND: {
                if (landAtLoc == null || !landAtLoc.isOwner(p.getUniqueId())) break;
                this.executeAction(clickAction, p, loc);
                break;
            }
            case OTHERLAND: {
                if (landAtLoc == null || landAtLoc.isOwner(p.getUniqueId())) break;
                this.executeAction(clickAction, p, loc);
                break;
            }
            case ANYLAND: {
                this.executeAction(clickAction, p, loc);
            }
        }
    }

    private void executeAction(ItemClickAction clickAction, Player p, Location loc) {
        switch (clickAction.getResult()) {
            case INFO: {
                this.plugin.getServer().dispatchCommand((CommandSender)p, "ll info");
                break;
            }
            case BUY: {
                this.plugin.getServer().dispatchCommand((CommandSender)p, "ll claim");
                break;
            }
            case MANAGE: {
                this.plugin.getServer().dispatchCommand((CommandSender)p, "ll manage");
                break;
            }
            case MANAGEALL: {
                this.plugin.getServer().dispatchCommand((CommandSender)p, "ll manageall");
                break;
            }
            case TOGGLEMAP: {
                this.plugin.getServer().dispatchCommand((CommandSender)p, "ll map");
                break;
            }
            case TOGGLEBORDERS: {
                this.plugin.getServer().dispatchCommand((CommandSender)p, "ll borders");
            }
        }
    }

    static enum ClickedAtCondition {
        LEFTCLICKBLOCK,
        RIGHTCLICKBLOCK,
        LEFTCLICKAIR,
        RIGHTCLICKAIR,
        SHIFTLEFTCLICKBLOCK,
        SHIFTRIGHTCLICKBLOCK,
        SHIFTLEFTCLICKAIR,
        SHIFTRIGHTCLICKAIR;

    }

    static enum ClickCondition {
        OWNLAND,
        OTHERLAND,
        ANYLAND;

    }

    static enum ClickResult {
        INFO,
        BUY,
        MANAGE,
        MANAGEALL,
        TOGGLEMAP,
        TOGGLEBORDERS;

    }

    static class ItemClickAction {
        private final ClickedAtCondition activation;
        private final ClickCondition condition;
        private final ClickResult result;

        public ItemClickAction(ClickedAtCondition activation, ClickCondition condition, ClickResult result) {
            this.activation = activation;
            this.condition = condition;
            this.result = result;
        }

        public ClickedAtCondition getActivation() {
            return this.activation;
        }

        public ClickCondition getCondition() {
            return this.condition;
        }

        public ClickResult getResult() {
            return this.result;
        }
    }
}

