/*
 * Decompiled with CFR 0.152.
 */
package biz.princeps.landlord.integrations;

import biz.princeps.landlord.api.ILandLord;
import biz.princeps.landlord.api.IOwnedLand;
import net.luckperms.api.LuckPerms;
import net.luckperms.api.context.ContextCalculator;
import net.luckperms.api.context.ContextConsumer;
import net.luckperms.api.context.ContextSet;
import net.luckperms.api.context.ImmutableContextSet;
import org.bukkit.entity.Player;
import org.bukkit.plugin.RegisteredServiceProvider;

public class LLLuckPerms {
    private final ILandLord plugin;
    private LuckPerms api;

    public LLLuckPerms(ILandLord plugin) {
        this.plugin = plugin;
        RegisteredServiceProvider provider = plugin.getServer().getServicesManager().getRegistration(LuckPerms.class);
        if (provider != null) {
            this.api = (LuckPerms)provider.getProvider();
        }
        this.api.getContextManager().registerCalculator((ContextCalculator)new CustomCalculator());
    }

    class CustomCalculator
    implements ContextCalculator<Player> {
        CustomCalculator() {
        }

        public void calculate(Player p, ContextConsumer contextConsumer) {
            IOwnedLand region = LLLuckPerms.this.plugin.getWGManager().getRegion(p.getLocation());
            if (region == null) {
                contextConsumer.accept("land", "wilderness");
            } else {
                contextConsumer.accept("land", region.getName());
                if (region.isOwner(p.getUniqueId())) {
                    contextConsumer.accept("land", "own");
                }
                if (region.isFriend(p.getUniqueId())) {
                    contextConsumer.accept("land", "befriended");
                }
            }
        }

        public ContextSet estimatePotentialContexts() {
            ImmutableContextSet.Builder builder = ImmutableContextSet.builder();
            builder.add("land", "wilderness");
            builder.add("land", "own");
            builder.add("land", "befriended");
            return builder.build();
        }
    }
}

