/*
 * Decompiled with CFR 0.152.
 */
package biz.princeps.landlord.guis;

import biz.princeps.landlord.api.ILandLord;
import biz.princeps.landlord.api.ILangManager;
import biz.princeps.landlord.api.IMaterialsManager;
import biz.princeps.landlord.api.IVaultManager;
import biz.princeps.landlord.manager.cost.ClaimsCostManager;
import biz.princeps.landlord.util.Skulls;
import biz.princeps.lib.gui.simple.AbstractGUI;
import biz.princeps.lib.gui.simple.Icon;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class ShopGUI
extends AbstractGUI {
    private final ILandLord plugin;
    private final ClaimsCostManager costManager;
    private final ILangManager lm;
    private final IMaterialsManager mats;
    private final IVaultManager vault;
    private int delta = 0;
    private double cost = 0.0;

    public ShopGUI(ILandLord plugin, Player player, String title) {
        super(plugin, player, 54, title);
        this.plugin = plugin;
        this.costManager = new ClaimsCostManager(plugin);
        this.mats = plugin.getMaterialsManager();
        this.lm = plugin.getLangManager();
        this.vault = plugin.getVaultManager();
    }

    @Override
    protected void create() {
        int lands = this.plugin.getWGManager().getRegionCount(this.player.getUniqueId());
        int claims = this.plugin.getPlayerManager().get(this.player.getUniqueId()).getClaims();
        int max = this.plugin.getPlayerManager().getMaxClaimPermission(this.player);
        for (int i = 0; i < this.getSize(); ++i) {
            Icon placehodler = new Icon(this.mats.getGreyStainedGlass());
            placehodler.setName(" ");
            this.setIcon(i, placehodler);
        }
        Icon yourLands = new Icon(new ItemStack(this.mats.getGrass()));
        yourLands.setName(this.lm.getRawString("Shop.gui.lands.name"));
        yourLands.setLore(this.replaceLore(this.lm.getStringList("Shop.gui.lands.lore"), "%amount%", String.valueOf(lands)));
        this.setIcon(0, yourLands);
        List<Skulls> landsSkulls = Skulls.numToSkull(lands);
        for (int i = 0; i < landsSkulls.size(); ++i) {
            Icon icon = new Icon(landsSkulls.get(i).getSkull(this.plugin));
            icon.setName(" ");
            this.setIcon(8 - landsSkulls.size() + 1 + i, icon);
        }
        ItemStack playerHead = this.mats.getPlayerHead(this.player.getUniqueId());
        Icon yourClaims = new Icon(playerHead);
        yourClaims.setName(this.lm.getRawString("Shop.gui.claims.name"));
        yourClaims.setLore(this.replaceLore(this.replaceLore(this.lm.getStringList("Shop.gui.claims.lore"), "%amount%", String.valueOf(claims + this.delta)), "%max%", String.valueOf(max)));
        this.setIcon(9, yourClaims);
        List<Skulls> claimsSkulls = Skulls.numToSkull(claims + this.delta);
        for (int i = 0; i < claimsSkulls.size(); ++i) {
            Icon icon = new Icon(claimsSkulls.get(i).getSkull(this.plugin));
            icon.setName(" ");
            this.setIcon(17 - claimsSkulls.size() + 1 + i, icon);
        }
        Icon costIcon = new Icon(Skulls.CASH.getSkull(this.plugin));
        this.setIcon(18, costIcon);
        List<Skulls> costSkulls = Skulls.numToSkull((int)this.cost);
        for (int i = 0; i < costSkulls.size(); ++i) {
            Icon icon = new Icon(costSkulls.get(i).getSkull(this.plugin));
            icon.setName(" ");
            this.setIcon(26 - costSkulls.size() + 1 + i, icon);
        }
        Icon back1 = new Icon(Skulls.BACK1.getSkull(this.plugin));
        back1.setName(this.lm.getRawString("Shop.gui.decrease1"));
        back1.addClickAction(p -> {
            if (claims + this.delta - 1 < 0) {
                return;
            }
            if (claims + this.delta - 1 < lands) {
                return;
            }
            --this.delta;
            this.cost -= this.costManager.calculateCost(claims + this.delta);
            this.refresh();
        });
        this.setIcon(30, back1);
        Icon back5 = new Icon(Skulls.BACK5.getSkull(this.plugin));
        back5.setName(this.lm.getRawString("Shop.gui.decrease5"));
        back5.addClickAction(p -> {
            if (claims + this.delta <= 0) {
                return;
            }
            if (claims + this.delta - 5 <= lands) {
                return;
            }
            if (claims + this.delta - 5 < 0) {
                this.cost -= this.costManager.calculateCost(claims + this.delta, -this.delta);
                this.delta = -claims;
            } else {
                this.cost -= this.costManager.calculateCost(claims + this.delta, -5);
                this.delta -= 5;
            }
            this.refresh();
        });
        this.setIcon(29, back5);
        Icon back10 = new Icon(Skulls.BACK10.getSkull(this.plugin));
        back10.setName(this.lm.getRawString("Shop.gui.decrease10"));
        back10.addClickAction(p -> {
            if (claims + this.delta <= 0) {
                return;
            }
            if (claims + this.delta - 10 <= lands) {
                return;
            }
            if (claims + this.delta - 10 < 0) {
                this.cost -= this.costManager.calculateCost(claims + this.delta, -this.delta);
                this.delta = -claims;
            } else {
                this.cost -= this.costManager.calculateCost(claims + this.delta, -10);
                this.delta -= 10;
            }
            this.refresh();
        });
        this.setIcon(28, back10);
        this.setIcon(31, yourClaims);
        Icon forw1 = new Icon(Skulls.FORWARD1.getSkull(this.plugin));
        forw1.setName(this.lm.getRawString("Shop.gui.increase1"));
        forw1.addClickAction(p -> {
            if (claims + this.delta + 1 > max) {
                return;
            }
            this.cost += this.costManager.calculateCost(claims + this.delta);
            ++this.delta;
            this.refresh();
        });
        this.setIcon(32, forw1);
        Icon forw5 = new Icon(Skulls.FORWARD5.getSkull(this.plugin));
        forw5.setName(this.lm.getRawString("Shop.gui.increase5"));
        forw5.addClickAction(p -> {
            if (claims + this.delta == max) {
                return;
            }
            if (claims + this.delta + 5 > max) {
                this.cost += this.costManager.calculateCost(claims + this.delta, max - claims - this.delta);
                this.delta = max - claims;
            } else {
                this.cost += this.costManager.calculateCost(claims + this.delta, 5);
                this.delta += 5;
            }
            this.refresh();
        });
        this.setIcon(33, forw5);
        Icon forw10 = new Icon(Skulls.FORWARD10.getSkull(this.plugin));
        forw10.setName(this.lm.getRawString("Shop.gui.increase10"));
        forw10.addClickAction(p -> {
            if (claims + this.delta == max) {
                return;
            }
            if (claims + this.delta + 10 > max) {
                this.cost += this.costManager.calculateCost(claims + this.delta, max - claims - this.delta);
                this.delta = max - claims;
            } else {
                this.cost += this.costManager.calculateCost(claims + this.delta, 10);
                this.delta += 10;
            }
            this.refresh();
        });
        this.setIcon(34, forw10);
        Icon abort = new Icon(Skulls.ABORT.getSkull(this.plugin));
        abort.setName(this.lm.getRawString("Shop.gui.abort"));
        abort.addClickAction(p -> {
            p.closeInventory();
            this.lm.sendMessage((CommandSender)p, this.lm.getString(this.player, "Shop.abort"));
        });
        this.setIcon(45, abort);
        if (this.vault.getBalance(this.player) < this.cost) {
            Icon error = new Icon(Skulls.REDEXCLAMATIONMARK.getSkull(this.plugin));
            error.setName(this.lm.getRawString("Shop.gui.error.name"));
            error.setLore(this.replaceLore(this.replaceLore(this.lm.getStringList("Shop.gui.error.lore"), "%cost%", this.vault.format(this.cost)), "%own%", "" + this.vault.format(this.vault.getBalance(this.player))));
            error.addClickAction(p -> this.lm.sendMessage((CommandSender)this.player, this.lm.getString(this.player, "Shop.notEnoughMoney").replace("%number%", String.valueOf(this.delta)).replace("%cost%", this.vault.format(this.cost))));
            this.setIcon(53, error);
        } else {
            Icon confirm = new Icon(Skulls.CONFIRM.getSkull(this.plugin));
            confirm.addClickAction(p -> {
                if (this.delta > 0) {
                    this.vault.take(p, this.cost);
                    this.plugin.getPlayerManager().get(p.getUniqueId()).addClaims(this.delta);
                    this.lm.sendMessage((CommandSender)p, this.lm.getString(p, "Shop.successBuy").replace("%number%", String.valueOf(this.delta)).replace("%cost%", this.vault.format(this.cost)));
                } else {
                    this.vault.give(p, this.cost * -1.0);
                    this.plugin.getPlayerManager().get(p.getUniqueId()).addClaims(this.delta);
                    this.lm.sendMessage((CommandSender)p, this.lm.getString(p, "Shop.successSell").replace("%number%", String.valueOf(-1 * this.delta)).replace("%cost%", this.vault.format(-1.0 * this.cost)));
                }
                p.closeInventory();
            });
            confirm.setName(this.lm.getRawString("Shop.gui.confirm.name"));
            confirm.setLore(this.replaceLore(this.replaceLore(this.lm.getStringList("Shop.gui.confirm.lore"), "%delta%", String.valueOf(this.delta)), "%price%", this.vault.format(this.cost)));
            this.setIcon(53, confirm);
        }
    }

    private List<String> replaceLore(List<String> list, String toReplace, String newValue) {
        ArrayList<String> newList = new ArrayList<String>();
        for (String s : list) {
            newList.add(s.replace(toReplace, newValue));
        }
        return newList;
    }
}

