/*
 * Decompiled with CFR 0.152.
 */
package biz.princeps.landlord.guis;

import biz.princeps.landlord.api.ClearType;
import biz.princeps.landlord.api.ILandLord;
import biz.princeps.landlord.api.ILangManager;
import biz.princeps.landlord.api.IMultiTaskManager;
import biz.princeps.landlord.api.IOwnedLand;
import biz.princeps.landlord.api.IWorldGuardManager;
import biz.princeps.landlord.multi.MultiClearTask;
import biz.princeps.lib.gui.ConfirmationGUI;
import biz.princeps.lib.gui.simple.AbstractGUI;
import biz.princeps.lib.gui.simple.Icon;
import java.util.Arrays;
import java.util.Collections;
import java.util.UUID;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class ClearGUI
extends AbstractGUI {
    private final ILandLord plugin;
    private final ILangManager lm;
    private final IWorldGuardManager wg;
    private final IMultiTaskManager multiTaskManager;

    public ClearGUI(ILandLord plugin, Player player) {
        super(plugin, player, 9, plugin.getLangManager().getRawString("Commands.Clear.gui.title"));
        this.plugin = plugin;
        this.lm = plugin.getLangManager();
        this.wg = plugin.getWGManager();
        this.multiTaskManager = plugin.getMultiTaskManager();
    }

    @Override
    protected void create() {
        IOwnedLand land = this.wg.getRegion(this.player.getLocation());
        int pos = 0;
        if (land != null) {
            if (this.player.hasPermission("landlord.admin.clear.land")) {
                Icon i1 = new Icon(new ItemStack(this.plugin.getMaterialsManager().getGrass()));
                i1.setName(this.lm.getRawString("Commands.Clear.gui.clearcurrentland.name"));
                i1.setLore(Arrays.asList(this.lm.getRawString("Commands.Clear.gui.clearcurrentland.desc").split("\\|")));
                i1.addClickAction(player1 -> {
                    ConfirmationGUI confirm = new ConfirmationGUI(this.plugin, player1, this.lm.getRawString("Commands.Clear.gui.clearcurrentland.confirm"), a -> {
                        this.clearLand(land);
                        a.closeInventory();
                    }, d -> {
                        this.lm.sendMessage((CommandSender)d, this.lm.getString(this.player, "Commands.Clear.gui.clearcurrentland.abort"));
                        d.closeInventory();
                    }, this);
                    confirm.display();
                });
                this.setIcon(pos++, i1);
            }
            if (this.player.hasPermission("landlord.admin.clear.player")) {
                Icon i2 = new Icon(this.plugin.getMaterialsManager().getPlayerHead(land.getOwner()));
                i2.setName(this.lm.getRawString("Commands.Clear.gui.clearplayer.name"));
                i2.setLore(Arrays.asList(this.lm.getRawString("Commands.Clear.gui.clearplayer.desc").split("\\|")));
                i2.addClickAction(player1 -> {
                    ConfirmationGUI confirm = new ConfirmationGUI(this.plugin, player1, this.lm.getRawString("Commands.Clear.gui.clearplayer.confirm"), a -> {
                        this.clearPlayer(land.getOwner());
                        a.closeInventory();
                    }, d -> {
                        this.lm.sendMessage((CommandSender)d, this.lm.getString(this.player, "Commands.Clear.gui.clearplayer.abort"));
                        d.closeInventory();
                    }, this);
                    confirm.display();
                });
                this.setIcon(pos++, i2);
            }
        }
        if (this.player.hasPermission("landlord.admin.clear.world")) {
            Icon i3 = new Icon(new ItemStack(this.plugin.getMaterialsManager().getFireCharge()));
            i3.setName(this.lm.getRawString("Commands.Clear.gui.clearworld.name"));
            i3.setLore(Arrays.asList(this.lm.getRawString("Commands.Clear.gui.clearworld.desc").split("\\|")));
            i3.addClickAction(player1 -> {
                ConfirmationGUI confirm = new ConfirmationGUI(this.plugin, player1, this.lm.getRawString("Commands.Clear.gui.clearworld.confirm").replace("%world%", this.player.getWorld().getName()), a -> {
                    this.clearWorld(a.getWorld());
                    a.closeInventory();
                }, d -> {
                    this.lm.sendMessage((CommandSender)d, this.lm.getString(this.player, "Commands.Clear.gui.clearworld.abort"));
                    d.closeInventory();
                }, this);
                confirm.display();
            });
            this.setIcon(pos++, i3);
        }
    }

    private void clearLand(IOwnedLand land) {
        if (!this.player.hasPermission("landlord.admin.clear.land")) {
            this.lm.sendMessage((CommandSender)this.player, this.lm.getString(this.player, "noPermissions"));
        }
        this.wg.unclaim(Collections.singleton(land));
        this.lm.sendMessage((CommandSender)this.player, this.lm.getString(this.player, "Commands.Clear.gui.clearcurrentland.success").replace("%land%", land.getName()));
    }

    private void clearWorld(World world) {
        if (!this.player.hasPermission("landlord.admin.clear.world")) {
            this.lm.sendMessage((CommandSender)this.player, this.lm.getString(this.player, "noPermissions"));
        }
        this.multiTaskManager.enqueueTask(new MultiClearTask(this.plugin, (CommandSender)this.player, this.wg.getRegions(world), world.getName(), ClearType.WORLD));
    }

    private void clearPlayer(UUID id) {
        if (!this.player.hasPermission("landlord.admin.clear.player")) {
            this.lm.sendMessage((CommandSender)this.player, this.lm.getString(this.player, "noPermissions"));
        }
        this.plugin.getPlayerManager().getOffline(id, lPlayer -> {
            if (lPlayer == null) {
                this.lm.sendMessage((CommandSender)this.player, this.lm.getString(this.player, "Commands.Clear.noPlayer").replace("%players%", id.toString()));
            } else {
                this.multiTaskManager.enqueueTask(new MultiClearTask(this.plugin, (CommandSender)this.player, this.wg.getRegions(lPlayer.getUuid()), lPlayer.getName(), ClearType.PLAYER));
            }
        });
    }
}

