/*
 * Decompiled with CFR 0.152.
 */
package biz.princeps.landlord.guis;

import biz.princeps.landlord.api.ILLFlag;
import biz.princeps.landlord.api.ILandLord;
import biz.princeps.landlord.api.ILangManager;
import biz.princeps.landlord.api.IMaterialsManager;
import biz.princeps.landlord.api.IMob;
import biz.princeps.landlord.api.IOwnedLand;
import biz.princeps.landlord.api.IPlayer;
import biz.princeps.landlord.api.ManageMode;
import biz.princeps.landlord.api.Options;
import biz.princeps.landlord.api.events.LandManageEvent;
import biz.princeps.landlord.commands.Landlordbase;
import biz.princeps.landlord.commands.friends.Unfriend;
import biz.princeps.landlord.commands.management.Manage;
import biz.princeps.landlord.multi.MultiMode;
import biz.princeps.lib.PrincepsLib;
import biz.princeps.lib.crossversion.MaterialProxy;
import biz.princeps.lib.gui.ConfirmationGUI;
import biz.princeps.lib.gui.MultiPagedGUI;
import biz.princeps.lib.gui.simple.AbstractGUI;
import biz.princeps.lib.gui.simple.Icon;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import net.md_5.bungee.api.chat.ClickEvent;
import net.md_5.bungee.api.chat.ComponentBuilder;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class AManage
extends AbstractGUI {
    private final List<IOwnedLand> regions;
    private final ILangManager lm;
    private final ILandLord plugin;
    private final Set<String> toggleMobs;
    private final IMaterialsManager mats;
    private final ManageMode manageMode;
    private final MultiMode multiMode;
    private final int radius;
    private int flagPage = 0;

    AManage(ILandLord plugin, Player player, String header, List<IOwnedLand> land, ManageMode manageMode, MultiMode multiMode, int radius) {
        super(plugin, player, 45, header);
        this.plugin = plugin;
        this.regions = land;
        this.lm = plugin.getLangManager();
        this.toggleMobs = new HashSet<String>(plugin.getConfig().getStringList("Manage.mob-spawning.toggleableMobs"));
        this.mats = plugin.getMaterialsManager();
        this.manageMode = manageMode;
        this.multiMode = multiMode;
        this.radius = radius;
    }

    AManage(ILandLord plugin, Player player, MultiPagedGUI landGui, String header, List<IOwnedLand> land, ManageMode manageMode, MultiMode multiMode, int radius) {
        super(plugin, player, 54, header, landGui);
        this.plugin = plugin;
        this.regions = land;
        this.lm = plugin.getLangManager();
        this.toggleMobs = new HashSet<String>(plugin.getConfig().getStringList("Manage.mob-spawning.toggleableMobs"));
        this.mats = plugin.getMaterialsManager();
        this.manageMode = manageMode;
        this.multiMode = multiMode;
        this.radius = radius;
    }

    @Override
    protected void create() {
        this.createFrame();
        this.createWGFlags();
        this.createGeneralOptions();
    }

    private void createFrame() {
        for (int i = 0; i < this.getSize(); ++i) {
            Icon placehodler = new Icon(this.mats.getGreyStainedGlass());
            placehodler.setName(" ");
            this.setIcon(i, placehodler);
        }
        List<String> strings = this.formatList(this.lm.getStringList("Commands.Manage.info.description"), "%land%", this.regions.get(0).getName());
        Icon info = new Icon(new ItemStack(Material.ITEM_FRAME));
        info.setName(this.lm.getRawString("Commands.Manage.info.title"));
        info.setLore(strings);
        this.setIcon(0, info);
        Icon friends = new Icon(this.mats.getPlayerHead(this.player.getUniqueId()));
        friends.setName(this.lm.getRawString("Commands.Manage.friends.title"));
        friends.setLore(this.lm.getStringList("Commands.Manage.friends.description"));
        this.setIcon(9, friends);
        Icon everyone = new Icon(this.mats.getWitherSkull());
        everyone.setName(this.lm.getRawString("Commands.Manage.everyone.title"));
        everyone.setLore(this.lm.getStringList("Commands.Manage.everyone.description"));
        this.setIcon(18, everyone);
    }

    private void createWGFlags() {
        IOwnedLand land = this.regions.get(0);
        ArrayList<Icon[]> flags = new ArrayList<Icon[]>();
        for (ILLFlag flag : land.getFlags()) {
            String flagName = flag.getName();
            if (!this.plugin.getConfig().getBoolean("Manage." + flagName + ".enable") || !this.player.hasPermission("landlord.player.manage." + flagName)) continue;
            flags.add(this.getIcons(flag));
        }
        if (this.flagPage * 8 > flags.size()) {
            throw new RuntimeException("Invalid page!");
        }
        for (int i = this.flagPage * 8; i < this.flagPage * 8 + 8 && flags.size() > i; ++i) {
            Icon[] flagArray = (Icon[])flags.get(i);
            this.setIcon(i - this.flagPage * 8 + 1, flagArray[0]);
            this.setIcon(i - this.flagPage * 8 + 10, flagArray[1]);
            this.setIcon(i - this.flagPage * 8 + 19, flagArray[2]);
        }
        if (flags.size() > 8) {
            Icon prev = new Icon(new ItemStack(Material.ARROW));
            prev.setName(this.lm.getRawString("Commands.Manage.prevArrow"));
            prev.addClickAction(p -> {
                if (this.flagPage > 0) {
                    --this.flagPage;
                    this.refresh();
                }
            });
            this.setIcon(34, prev);
            Icon next = new Icon(new ItemStack(Material.ARROW));
            next.setName(this.lm.getRawString("Commands.Manage.nextArrow"));
            next.addClickAction(p -> {
                if ((this.flagPage + 1) * 8 < flags.size()) {
                    ++this.flagPage;
                    this.refresh();
                }
            });
            this.setIcon(35, next);
        }
    }

    private Icon[] getIcons(final ILLFlag flag) {
        Icon[] icons = new Icon[3];
        String flagname = flag.getName();
        String title = this.lm.getRawString("Commands.Manage.Allow" + flagname.substring(0, 1).toUpperCase() + flagname.substring(1) + ".title");
        List<String> description = this.lm.getStringList("Commands.Manage.Allow" + flagname.substring(0, 1).toUpperCase() + flagname.substring(1) + ".description");
        Icon item = new Icon(new ItemStack(flag.getMaterial()));
        item.setLore(description);
        item.setName(title);
        icons[0] = item;
        boolean isFriend = flag.getFriendStatus();
        boolean isAll = flag.getAllStatus();
        Icon friend = new Icon(isFriend ? this.mats.getLimeWool() : this.mats.getRedWool());
        friend.addClickAction(p -> {
            if (flag.toggleFriends()) {
                this.refresh();
                new BukkitRunnable(){

                    public void run() {
                        for (final IOwnedLand land : AManage.this.regions.subList(1, AManage.this.regions.size())) {
                            for (final ILLFlag landFlag : land.getFlags()) {
                                if (!flag.getName().equals(landFlag.getName()) || flag.getFriendStatus() == landFlag.getFriendStatus()) continue;
                                landFlag.toggleFriends();
                                new BukkitRunnable(){

                                    public void run() {
                                        LandManageEvent landManageEvent = new LandManageEvent(AManage.this.player, land, landFlag.getName(), !landFlag.getFriendStatus(), landFlag.getFriendStatus());
                                        AManage.this.plugin.getServer().getPluginManager().callEvent((Event)landManageEvent);
                                    }
                                }.runTask((Plugin)AManage.this.plugin);
                            }
                        }
                    }
                }.runTaskAsynchronously((Plugin)this.plugin);
            }
        });
        friend.setName(isFriend ? this.lm.getRawString("Commands.Manage.allow") : this.lm.getRawString("Commands.Manage.deny"));
        icons[1] = friend;
        Icon all = new Icon(isAll ? this.mats.getLimeWool() : this.mats.getRedWool());
        all.addClickAction(p -> {
            if (flag.toggleAll()) {
                this.refresh();
                new BukkitRunnable(){

                    public void run() {
                        for (final IOwnedLand land : AManage.this.regions.subList(1, AManage.this.regions.size())) {
                            for (final ILLFlag landFlag : land.getFlags()) {
                                if (!flag.getName().equals(landFlag.getName()) || flag.getAllStatus() == landFlag.getAllStatus()) continue;
                                landFlag.toggleAll();
                                new BukkitRunnable(){

                                    public void run() {
                                        LandManageEvent landManageEvent = new LandManageEvent(AManage.this.player, land, landFlag.getName(), !landFlag.getFriendStatus(), landFlag.getFriendStatus());
                                        AManage.this.plugin.getServer().getPluginManager().callEvent((Event)landManageEvent);
                                    }
                                }.runTask((Plugin)AManage.this.plugin);
                            }
                        }
                    }
                }.runTaskAsynchronously((Plugin)this.plugin);
            }
        });
        all.setName(isAll ? this.lm.getRawString("Commands.Manage.allow") : this.lm.getRawString("Commands.Manage.deny"));
        icons[2] = all;
        return icons;
    }

    private void createGeneralOptions() {
        String title;
        Icon icon;
        int position = 36;
        final IOwnedLand land = this.regions.get(0);
        String managecmd = PrincepsLib.getCommandManager().getCommand(Landlordbase.class).getCommandString(Manage.class);
        if (this.plugin.getConfig().getBoolean("Manage.setgreet.enable") && this.player.hasPermission("landlord.player.manage.setgreet")) {
            String currentGreet = land.getGreetMessage();
            List<String> greetDesc = this.lm.getStringList("Commands.Manage.SetGreet.description");
            icon = new Icon(new ItemStack(Material.valueOf((String)this.plugin.getConfig().getString("Manage.setgreet.item"))));
            icon.setName(this.lm.getRawString("Commands.Manage.SetGreet.title"));
            icon.setLore(this.formatList(greetDesc, "%var%", currentGreet));
            icon.addClickAction(p -> {
                p.closeInventory();
                ComponentBuilder builder = new ComponentBuilder(this.lm.getString(this.player, "Commands.Manage.SetGreet.clickMsg"));
                switch (this.manageMode) {
                    case ALL: {
                        builder.event(new ClickEvent(ClickEvent.Action.SUGGEST_COMMAND, managecmd + " setgreetall "));
                        break;
                    }
                    case MULTI: {
                        builder.event(new ClickEvent(ClickEvent.Action.SUGGEST_COMMAND, managecmd + " multisetgreet " + (Object)((Object)this.multiMode) + " " + this.radius));
                        break;
                    }
                    case ONE: {
                        builder.event(new ClickEvent(ClickEvent.Action.SUGGEST_COMMAND, managecmd + " setgreet "));
                    }
                }
                this.plugin.getUtilsManager().sendBasecomponent(p, builder.create());
            });
            this.setIcon(position++, icon);
        }
        if (this.plugin.getConfig().getBoolean("Manage.setfarewell.enable") && this.player.hasPermission("landlord.player.manage.setfarewell")) {
            List<String> farewellDesc = this.lm.getStringList("Commands.Manage.SetFarewell.description");
            String currentFarewell = land.getFarewellMessage();
            icon = new Icon(new ItemStack(Material.valueOf((String)this.plugin.getConfig().getString("Manage.setfarewell.item"))));
            icon.setName(this.lm.getRawString("Commands.Manage.SetFarewell.title"));
            icon.setLore(this.formatList(farewellDesc, "%var%", currentFarewell));
            icon.addClickAction(p -> {
                p.closeInventory();
                ComponentBuilder builder = new ComponentBuilder(this.lm.getString(this.player, "Commands.Manage.SetFarewell.clickMsg"));
                switch (this.manageMode) {
                    case ALL: {
                        builder.event(new ClickEvent(ClickEvent.Action.SUGGEST_COMMAND, managecmd + " setfarewellall "));
                        break;
                    }
                    case MULTI: {
                        builder.event(new ClickEvent(ClickEvent.Action.SUGGEST_COMMAND, managecmd + " multisetfarewell " + (Object)((Object)this.multiMode) + " " + this.radius));
                        break;
                    }
                    case ONE: {
                        builder.event(new ClickEvent(ClickEvent.Action.SUGGEST_COMMAND, managecmd + " setfarewell "));
                    }
                }
                this.plugin.getUtilsManager().sendBasecomponent(p, builder.create());
            });
            this.setIcon(position++, icon);
        }
        if (this.plugin.getConfig().getBoolean("Manage.friends.enable") && this.player.hasPermission("landlord.player.manage.friends")) {
            Icon icon2 = new Icon(this.mats.getPlayerHead(this.player.getUniqueId()));
            icon2.setName(this.lm.getRawString("Commands.Manage.ManageFriends.title"));
            icon2.setLore(this.lm.getStringList("Commands.Manage.ManageFriends.description"));
            final Set<UUID> friends = land.getFriends();
            final boolean canSpread = this.plugin.getConfig().getBoolean("Manage.spread-friends.enable") && this.player.hasPermission("landlord.player.manage.spreadfriends") && this.manageMode != ManageMode.ONE;
            MultiPagedGUI friendsGui = new MultiPagedGUI(this.plugin, this.player, (int)Math.ceil((double)friends.size() / 9.0), this.lm.getRawString("Commands.Manage.ManageFriends.title"), new ArrayList(), this){

                @Override
                protected void generateStaticIcons() {
                    if (canSpread) {
                        String spreadTitle = AManage.this.lm.getRawString("Commands.Manage.AllowSpread-friends.title");
                        Material material = Material.valueOf((String)AManage.this.plugin.getConfig().getString("Manage.spread-friends.item"));
                        Icon spreadIcon = new Icon(new ItemStack(material));
                        spreadIcon.setName(spreadTitle);
                        spreadIcon.setLore(AManage.this.lm.getStringList("Commands.Manage.AllowSpread-friends.description"));
                        spreadIcon.addClickAction(p -> new BukkitRunnable(){

                            public void run() {
                                Set<UUID> defaultFriends = land.getFriends();
                                for (final IOwnedLand region : AManage.this.regions.subList(1, AManage.this.regions.size())) {
                                    final String oldfriends = region.getMembersString();
                                    for (UUID landFriend : region.getFriends()) {
                                        if (land.isFriend(landFriend)) continue;
                                        region.removeFriend(landFriend);
                                    }
                                    for (UUID defaultFriend : defaultFriends) {
                                        if (region.isFriend(defaultFriend)) continue;
                                        region.addFriend(defaultFriend);
                                    }
                                    new BukkitRunnable(){

                                        public void run() {
                                            LandManageEvent landManageEvent = new LandManageEvent(player, region, "FRIENDS", oldfriends, region.getMembersString());
                                            AManage.this.plugin.getServer().getPluginManager().callEvent((Event)landManageEvent);
                                        }
                                    }.runTask((Plugin)AManage.this.plugin);
                                }
                            }
                        }.runTaskAsynchronously((Plugin)AManage.this.plugin));
                        this.setIcon((int)Math.ceil((double)friends.size() / 9.0) + 1, spreadIcon);
                    }
                }
            };
            String rawTitle = this.lm.getRawString("Commands.Manage.ManageFriends.unfriend");
            for (UUID id : friends) {
                OfflinePlayer op = this.plugin.getServer().getOfflinePlayer(id);
                Icon friend = new Icon(this.mats.getPlayerHead(id));
                String name = op != null && op.getName() != null ? op.getName() : "OfflinePlayer";
                String confititle = rawTitle.replace("%player%", name);
                friend.setName(name);
                friend.setLore(this.formatFriendsSegment(id));
                friend.addClickAction(player -> {
                    ConfirmationGUI confirmationGUI = new ConfirmationGUI(this.plugin, this.player, confititle, p -> {
                        friendsGui.removeIcon(friend);
                        for (IOwnedLand region : this.regions) {
                            this.plugin.getServer().dispatchCommand((CommandSender)player, PrincepsLib.getCommandManager().getCommand(Landlordbase.class).getCommandString(Unfriend.class).substring(1) + " " + name + " " + region.getName());
                        }
                        player.closeInventory();
                        friendsGui.display();
                    }, p -> {
                        player.closeInventory();
                        friendsGui.display();
                    }, friendsGui);
                    confirmationGUI.setConfirm(this.lm.getRawString("Confirmation.accept"));
                    confirmationGUI.setDecline(this.lm.getRawString("Confirmation.decline"));
                    confirmationGUI.display();
                });
                friendsGui.addIcon(friend);
            }
            int friendPosition = position;
            icon2.addClickAction(p -> {
                friendsGui.generateAsync().display();
                this.setIcon(friendPosition, new Icon(MaterialProxy.CLOCK.crossVersion()).setName(this.lm.getRawString("pleaseWait")));
            });
            this.setIcon(position++, icon2);
        }
        ConfigurationSection cs = this.plugin.getConfig().getConfigurationSection("Manage.commands");
        Set keys = cs.getKeys(false);
        for (String key : keys) {
            if (!this.plugin.getConfig().getBoolean("Manage.commands." + key + ".enable") || !this.player.hasPermission("landlord.player.manage." + key) || this.manageMode != ManageMode.ONE) continue;
            List<String> descri = this.lm.getStringList("Commands.Manage." + key + ".description");
            double cost = this.plugin.getConfig().getDouble("ResetCost");
            String costString = Options.isVaultEnabled() ? this.plugin.getVaultManager().format(cost) : "-1";
            Icon icon3 = new Icon(new ItemStack(Material.valueOf((String)this.plugin.getConfig().getString("Manage.commands." + key + ".item"))));
            icon3.setLore(this.formatList(this.formatList(descri, "%regencost%", costString), "%land%", land.getName()));
            icon3.setName(this.lm.getRawString("Commands.Manage." + key + ".title"));
            icon3.addClickAction(p -> this.plugin.getServer().dispatchCommand((CommandSender)this.player, this.plugin.getConfig().getString("Manage.commands." + key + ".cmd").replace("%land%", land.getName())));
            this.setIcon(position++, icon3);
        }
        if (this.plugin.getConfig().getBoolean("Manage.mob-spawning.enable") && this.player.hasPermission("landlord.player.manage.mob-spawning")) {
            title = this.lm.getRawString("Commands.Manage.AllowMob-spawning.title");
            Icon icon4 = new Icon(new ItemStack(Material.valueOf((String)this.plugin.getConfig().getString("Manage.mob-spawning.item"))));
            icon4.setName(title);
            icon4.setLore(this.lm.getStringList("Commands.Manage.AllowMob-spawning.description"));
            icon4.addClickAction(p -> {
                ArrayList icons = new ArrayList();
                final List<String> lore = this.lm.getStringList("Commands.Manage.AllowMob-spawning.toggleItem.description");
                final MultiPagedGUI gui = new MultiPagedGUI(this.plugin, p, 5, title, icons, this){

                    @Override
                    protected void generateStaticIcons() {
                        if (AManage.this.plugin.getConfig().getBoolean("Manage.spread-mobs.enable") && this.player.hasPermission("landlord.player.manage.spreadmobs") && AManage.this.manageMode != ManageMode.ONE) {
                            String spreadTitle = AManage.this.lm.getRawString("Commands.Manage.AllowSpread-mobs.title");
                            Material material = Material.valueOf((String)AManage.this.plugin.getConfig().getString("Manage.spread-mobs.item"));
                            Icon spreadIcon = new Icon(new ItemStack(material));
                            spreadIcon.setName(spreadTitle);
                            spreadIcon.setLore(AManage.this.lm.getStringList("Commands.Manage.AllowSpread-mobs.description"));
                            spreadIcon.addClickAction(p2 -> {
                                for (IMob m : AManage.this.plugin.getMobManager().values()) {
                                    if (!AManage.this.toggleMobs.contains(m.getName()) || !this.player.hasPermission(m.getPermission())) continue;
                                    for (IOwnedLand region : AManage.this.regions.subList(1, AManage.this.regions.size())) {
                                        if (land.isMobDenied(m) == region.isMobDenied(m)) continue;
                                        region.toggleMob(m);
                                    }
                                }
                            });
                            this.setIcon(46, spreadIcon);
                        }
                    }
                };
                String titleMob = this.lm.getRawString("Commands.Manage.AllowMob-spawning.toggleItem.title");
                for (final IMob m : this.plugin.getMobManager().values()) {
                    if (!this.toggleMobs.contains(m.getName()) || !this.player.hasPermission(m.getPermission())) continue;
                    final Icon mob = new Icon(m.getEgg());
                    mob.setName(titleMob.replace("%mob%", m.getNiceName()));
                    mob.setLore(this.formatList(this.formatList(lore, "%value%", this.formatMobState(land.isMobDenied(m))), "%mob%", m.getNiceName()));
                    this.setGlowing(mob.itemStack, !land.isMobDenied(m));
                    gui.addIcon(mob);
                    mob.addClickAction(p1 -> {
                        land.toggleMob(m);
                        new BukkitRunnable(){

                            public void run() {
                                for (IOwnedLand region : AManage.this.regions.subList(1, AManage.this.regions.size())) {
                                    if (region.isMobDenied(m) == land.isMobDenied(m)) continue;
                                    region.toggleMob(m);
                                }
                                mob.setLore(AManage.this.formatList(AManage.this.formatList(lore, "%value%", AManage.this.formatMobState(land.isMobDenied(m))), "%mob%", m.getNiceName()));
                                AManage.this.setGlowing(mob.itemStack, !land.isMobDenied(m));
                                gui.refresh();
                            }
                        }.runTaskAsynchronously((Plugin)this.plugin);
                    });
                }
                gui.display();
            });
            this.setIcon(position++, icon4);
        }
        if (this.plugin.getConfig().getBoolean("Manage.spread-flags.enable") && this.player.hasPermission("landlord.player.manage.spreadflags") && this.manageMode != ManageMode.ONE) {
            title = this.lm.getRawString("Commands.Manage.AllowSpread-flags.title");
            Material material = Material.valueOf((String)this.plugin.getConfig().getString("Manage.spread-flags.item"));
            Icon icon5 = new Icon(new ItemStack(material));
            icon5.setName(title);
            icon5.setLore(this.lm.getStringList("Commands.Manage.AllowSpread-flags.description"));
            icon5.addClickAction(p -> new BukkitRunnable(){

                public void run() {
                    for (int flagI = 0; flagI < land.getFlags().size(); ++flagI) {
                        ILLFlag defaultFlag = land.getFlags().get(flagI);
                        for (IOwnedLand region : AManage.this.regions.subList(1, AManage.this.regions.size())) {
                            final ILLFlag landFlag = region.getFlags().get(flagI);
                            if (defaultFlag.getFriendStatus() != landFlag.getFriendStatus()) {
                                landFlag.toggleFriends();
                                new BukkitRunnable(){

                                    public void run() {
                                        LandManageEvent landManageEvent = new LandManageEvent(AManage.this.player, land, landFlag.getName(), !landFlag.getFriendStatus(), landFlag.getFriendStatus());
                                        AManage.this.plugin.getServer().getPluginManager().callEvent((Event)landManageEvent);
                                    }
                                }.runTask((Plugin)AManage.this.plugin);
                            }
                            if (defaultFlag.getAllStatus() == landFlag.getAllStatus()) continue;
                            landFlag.toggleAll();
                            new BukkitRunnable(){

                                public void run() {
                                    LandManageEvent landManageEvent = new LandManageEvent(AManage.this.player, land, landFlag.getName(), !landFlag.getAllStatus(), landFlag.getAllStatus());
                                    AManage.this.plugin.getServer().getPluginManager().callEvent((Event)landManageEvent);
                                }
                            }.runTask((Plugin)AManage.this.plugin);
                        }
                    }
                    for (IOwnedLand region : AManage.this.regions) {
                        region.setFarewellMessage(land.getFarewellMessage());
                        region.setGreetMessage(land.getGreetMessage());
                    }
                }
            }.runTaskAsynchronously((Plugin)this.plugin));
            this.setIcon(position++, icon5);
        }
    }

    private String formatMobState(boolean bool) {
        if (bool) {
            return this.lm.getRawString("Commands.Manage.AllowMob-spawning.toggleItem.deny");
        }
        return this.lm.getRawString("Commands.Manage.AllowMob-spawning.toggleItem.allow");
    }

    private void setGlowing(ItemStack stack, boolean glowing) {
        ItemMeta itemMeta = stack.getItemMeta();
        if (glowing) {
            itemMeta.addEnchant(Enchantment.DAMAGE_ALL, 1, false);
            itemMeta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ENCHANTS});
        } else {
            itemMeta.removeEnchant(Enchantment.DAMAGE_ALL);
            itemMeta.removeItemFlags(new ItemFlag[]{ItemFlag.HIDE_ENCHANTS});
        }
        stack.setItemMeta(itemMeta);
    }

    private List<String> formatList(List<String> list, String toReplace, String newValue) {
        ArrayList<String> newList = new ArrayList<String>();
        for (String s : list) {
            newList.add(s.replace(toReplace, newValue));
        }
        return newList;
    }

    private List<String> formatFriendsSegment(UUID id) {
        OfflinePlayer op = this.plugin.getServer().getOfflinePlayer(id);
        ArrayList<String> toReturn = new ArrayList<String>();
        IPlayer offline = this.plugin.getPlayerManager().getOfflineSync(id);
        List<String> stringList = this.lm.getStringList("Commands.Manage.ManageFriends.friendSegment");
        String lastseen = op.isOnline() ? this.lm.getRawString("Commands.Info.online") : (offline != null ? offline.getLastSeen().toString() : "NaN");
        for (String s : stringList) {
            String ss = s.replace("%seen%", lastseen);
            toReturn.add(ss);
        }
        return toReturn;
    }
}

