/*
 * Decompiled with CFR 0.152.
 */
package biz.princeps.landlord.commands.management.borders;

import biz.princeps.landlord.api.ILandLord;
import biz.princeps.landlord.api.IOwnedLand;
import biz.princeps.landlord.api.IWorldGuardManager;
import org.bukkit.Particle;
import org.bukkit.entity.Player;
import org.bukkit.scheduler.BukkitRunnable;

public class BordersTask
extends BukkitRunnable {
    private final ILandLord plugin;
    private final IWorldGuardManager wg;
    private final Player player;
    private final int refreshRate;
    private final int timeout;
    private int counter;

    BordersTask(ILandLord plugin, Player player) {
        this.plugin = plugin;
        this.wg = plugin.getWGManager();
        this.player = player;
        this.refreshRate = plugin.getConfig().getInt("Borders.refreshRate");
        this.timeout = plugin.getConfig().getInt("Borders.timeout");
    }

    public void run() {
        if (this.counter * this.refreshRate <= this.timeout) {
            if (this.plugin.getConfig().getBoolean("Particles.borders.enabled")) {
                IOwnedLand ownedLand = this.wg.getRegion(this.player.getLocation());
                if (ownedLand == null) {
                    this.wg.highlightLand(this.player.getLocation().getChunk(), this.player, Particle.valueOf((String)this.plugin.getConfig().getString("Particles.borders.unclaimed")), 1, false);
                } else {
                    this.plugin.getPlayerManager().getOffline(ownedLand.getOwner(), owner -> {
                        if (this.plugin.getPlayerManager().isInactive(owner.getLastSeen())) {
                            this.wg.highlightLand(this.player.getLocation().getChunk(), this.player, Particle.valueOf((String)this.plugin.getConfig().getString("Particles.borders.inactive")), 1, false);
                        } else {
                            this.wg.highlightLand(this.player.getLocation().getChunk(), this.player, Particle.valueOf((String)this.plugin.getConfig().getString("Particles.borders.claimed")), 1, false);
                        }
                    });
                }
            }
        } else {
            this.cancel();
        }
        ++this.counter;
    }

    public void start() {
        this.runTaskTimer(this.plugin, 0L, (long)this.refreshRate * 20L);
    }
}

