/*
 * Decompiled with CFR 0.152.
 */
package biz.princeps.landlord.commands.management;

import biz.princeps.landlord.api.ILandLord;
import biz.princeps.landlord.api.IOwnedLand;
import biz.princeps.landlord.api.IWorldGuardManager;
import biz.princeps.landlord.api.Options;
import biz.princeps.landlord.api.events.LandManageEvent;
import biz.princeps.landlord.commands.LandlordCommand;
import biz.princeps.lib.command.Arguments;
import biz.princeps.lib.command.Properties;
import biz.princeps.lib.gui.ConfirmationGUI;
import com.google.common.collect.Sets;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class Regenerate
extends LandlordCommand {
    private final IWorldGuardManager wg;

    public Regenerate(ILandLord plugin) {
        super(plugin, plugin.getConfig().getString("CommandSettings.Regenerate.name"), plugin.getConfig().getString("CommandSettings.Regenerate.usage"), Sets.newHashSet((Iterable)plugin.getConfig().getStringList("CommandSettings.Regenerate.permissions")), Sets.newHashSet((Iterable)plugin.getConfig().getStringList("CommandSettings.Regenerate.aliases")));
        this.wg = plugin.getWGManager();
    }

    @Override
    public void onCommand(Properties properties, Arguments arguments) {
        if (properties.isConsole()) {
            return;
        }
        final Player player = properties.getPlayer();
        if (this.isDisabledWorld(player)) {
            return;
        }
        IOwnedLand land = this.wg.getRegion(player.getLocation());
        if (arguments.size() == 1) {
            land = this.wg.getRegion(arguments.get(0));
        }
        if (land == null || !land.isOwner(player.getUniqueId())) {
            this.plugin.getLangManager().sendMessage((CommandSender)player, "Commands.Regenerate.notOwn");
        } else {
            double cost = this.plugin.getConfig().getDouble("ResetCost");
            String costString = Options.isVaultEnabled() ? this.plugin.getVaultManager().format(cost) : "-1";
            final IOwnedLand finalLand = land;
            ConfirmationGUI confi = new ConfirmationGUI(this.plugin, player, this.lm.getRawString("Commands.Regenerate.confirmation").replace("%cost%", costString), p1 -> {
                boolean flag = true;
                if (Options.isVaultEnabled()) {
                    if (this.plugin.getVaultManager().hasBalance(player, cost)) {
                        this.plugin.getVaultManager().take(player, cost);
                    } else {
                        this.lm.sendMessage((CommandSender)player, this.lm.getString(player, "Commands.Regenerate.notEnoughMoney").replace("%cost%", costString).replace("%name%", finalLand.getName()));
                        flag = false;
                    }
                }
                if (flag) {
                    new BukkitRunnable(){

                        public void run() {
                            LandManageEvent landManageEvent = new LandManageEvent(player, finalLand, null, "REGENERATE", "REGENERATE");
                            Regenerate.this.plugin.getServer().getPluginManager().callEvent((Event)landManageEvent);
                        }
                    }.runTask((Plugin)this.plugin);
                    this.plugin.getRegenerationManager().regenerateChunk(finalLand.getALocation());
                    this.lm.sendMessage((CommandSender)player, this.lm.getString(player, "Commands.Regenerate.success").replace("%land%", finalLand.getName()));
                    player.closeInventory();
                }
            }, p2 -> this.lm.sendMessage((CommandSender)player, this.lm.getString(player, "Commands.Regenerate.abort").replace("%land%", finalLand.getName())), null);
            confi.setConfirm(this.lm.getRawString("Confirmation.accept"));
            confi.setDecline(this.lm.getRawString("Confirmation.decline"));
            confi.display();
        }
    }
}

