/*
 * Decompiled with CFR 0.152.
 */
package biz.princeps.landlord.commands.management;

import biz.princeps.landlord.api.ILandLord;
import biz.princeps.landlord.api.IOwnedLand;
import biz.princeps.landlord.api.IWorldGuardManager;
import biz.princeps.landlord.api.ManageMode;
import biz.princeps.landlord.commands.LandlordCommand;
import biz.princeps.landlord.guis.ManageGuiAll;
import biz.princeps.landlord.multi.MultiMode;
import biz.princeps.lib.command.Arguments;
import biz.princeps.lib.command.Properties;
import biz.princeps.lib.exception.ArgumentsOutOfBoundsException;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class MultiManage
extends LandlordCommand {
    private final IWorldGuardManager wg;

    public MultiManage(ILandLord plugin) {
        super(plugin, plugin.getConfig().getString("CommandSettings.MultiManage.name"), plugin.getConfig().getString("CommandSettings.MultiManage.usage"), Sets.newHashSet((Iterable)plugin.getConfig().getStringList("CommandSettings.MultiManage.permissions")), Sets.newHashSet((Iterable)plugin.getConfig().getStringList("CommandSettings.MultiManage.aliases")));
        this.wg = plugin.getWGManager();
    }

    @Override
    public void onCommand(Properties properties, Arguments arguments) {
        int radius;
        MultiMode mode;
        if (properties.isConsole()) {
            properties.sendMessage("Player command only!");
            return;
        }
        if (arguments.size() != 2) {
            properties.sendUsage();
            return;
        }
        try {
            mode = MultiMode.valueOf(arguments.get(0).toUpperCase());
            radius = arguments.getInt(1);
        }
        catch (ArgumentsOutOfBoundsException | IllegalArgumentException ex) {
            properties.sendUsage();
            return;
        }
        Player player = properties.getPlayer();
        ArrayList<IOwnedLand> lands = new ArrayList<IOwnedLand>(mode.getLandsOf(radius, player.getLocation(), player.getUniqueId(), this.wg));
        if (lands.size() == 0) {
            this.lm.sendMessage((CommandSender)player, this.plugin.getLangManager().getString("Commands.ListLands.noLands"));
            return;
        }
        ManageGuiAll gui = new ManageGuiAll(this.plugin, player, lands, ManageMode.MULTI, mode, radius);
        gui.display();
    }
}

