/*
 * Decompiled with CFR 0.152.
 */
package biz.princeps.landlord.commands.management;

import biz.princeps.landlord.api.ILLFlag;
import biz.princeps.landlord.api.ILandLord;
import biz.princeps.landlord.api.IOwnedLand;
import biz.princeps.landlord.api.IPlayer;
import biz.princeps.landlord.api.IWorldGuardManager;
import biz.princeps.landlord.api.ManageMode;
import biz.princeps.landlord.commands.LandlordCommand;
import biz.princeps.landlord.commands.Landlordbase;
import biz.princeps.landlord.commands.management.ListLands;
import biz.princeps.landlord.guis.ManageGui;
import biz.princeps.landlord.guis.ManageGuiAll;
import biz.princeps.landlord.multi.MultiMode;
import biz.princeps.lib.PrincepsLib;
import biz.princeps.lib.chat.MultiPagedMessage;
import biz.princeps.lib.command.Arguments;
import biz.princeps.lib.command.Properties;
import biz.princeps.lib.exception.ArgumentsOutOfBoundsException;
import biz.princeps.lib.gui.MultiPagedGUI;
import biz.princeps.lib.gui.simple.Icon;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class MultiListLands
extends LandlordCommand {
    private final IWorldGuardManager wg;

    public MultiListLands(ILandLord plugin) {
        super(plugin, plugin.getConfig().getString("CommandSettings.MultiListLands.name"), plugin.getConfig().getString("CommandSettings.MultiListLands.usage"), Sets.newHashSet((Iterable)plugin.getConfig().getStringList("CommandSettings.MultiListLands.permissions")), Sets.newHashSet((Iterable)plugin.getConfig().getStringList("CommandSettings.MultiListLands.aliases")));
        this.wg = plugin.getWGManager();
    }

    @Override
    public void onCommand(Properties properties, Arguments arguments) {
        if (properties.isPlayer()) {
            int radius;
            MultiMode mode;
            String target = null;
            int page = 0;
            try {
                switch (arguments.size()) {
                    case 4: {
                        target = arguments.get(2);
                        page = arguments.getInt(3);
                        break;
                    }
                    case 3: {
                        target = arguments.get(2);
                    }
                }
                mode = MultiMode.valueOf(arguments.get(0).toUpperCase());
                radius = arguments.getInt(1);
            }
            catch (ArgumentsOutOfBoundsException ignored) {
                properties.sendUsage();
                return;
            }
            if (target == null) {
                this.onListLands(properties.getPlayer(), mode, radius, this.plugin.getPlayerManager().get(properties.getPlayer().getUniqueId()), page);
            } else if (properties.getPlayer().hasPermission("landlord.admin.list")) {
                String finalTarget = target;
                int finalPage = page;
                this.plugin.getPlayerManager().getOffline(target, lPlayer -> {
                    if (lPlayer == null) {
                        properties.getPlayer().sendMessage(this.lm.getString(properties.getPlayer(), "Commands.MultiListLands.noPlayer").replace("%player%", finalTarget));
                    } else {
                        this.onListLands(properties.getPlayer(), mode, radius, (IPlayer)lPlayer, finalPage);
                    }
                });
            }
        }
    }

    private void onListLands(final Player sender, final MultiMode mode, final int radius, final IPlayer target, final int page) {
        if (this.isDisabledWorld(sender)) {
            return;
        }
        new BukkitRunnable(){

            public void run() {
                final ArrayList<IOwnedLand> lands = new ArrayList<IOwnedLand>(mode.getLandsOf(radius, sender.getLocation(), target.getUuid(), MultiListLands.this.wg));
                if (lands.size() == 0) {
                    MultiListLands.this.lm.sendMessage((CommandSender)sender, MultiListLands.this.plugin.getLangManager().getString("Commands.MultiListLands.noLands"));
                    return;
                }
                String confirmMode = MultiListLands.this.plugin.getConfig().getString("CommandSettings.MultiListLands.mode");
                if (confirmMode.equals("gui")) {
                    final MultiPagedGUI landGui = new MultiPagedGUI(MultiListLands.this.plugin, sender, 5, MultiListLands.this.plugin.getLangManager().getRawString("Commands.MultiListLands.gui.header").replace("%player%", target.getName())){

                        @Override
                        protected void generateStaticIcons() {
                            this.setIcon(52, new Icon(new ItemStack(Material.BEACON)).setName(MultiListLands.this.lm.getRawString("Commands.MultiListLands.gui.multiManage")).addClickAction(p -> {
                                ManageGuiAll manageGUIAll = new ManageGuiAll(MultiListLands.this.plugin, sender, this, (List<IOwnedLand>)lands, ManageMode.MULTI, mode, radius);
                                manageGUIAll.display();
                            }));
                        }
                    };
                    for (IOwnedLand land : lands) {
                        List<String> loreRaw = MultiListLands.this.plugin.getLangManager().getStringList("Commands.MultiListLands.gui.lore");
                        ArrayList<String> lore = new ArrayList<String>();
                        for (String s : loreRaw) {
                            if (s.contains("%flags%")) {
                                String flagFormat = MultiListLands.this.lm.getRawString("Commands.MultiListLands.gui.flagformat");
                                for (ILLFlag flag : land.getFlags()) {
                                    lore.add(flagFormat.replace("%flagname%", flag.getName()).replace("%friend%", MultiListLands.this.formatState(flag.getFriendStatus())).replace("%all%", MultiListLands.this.formatState(flag.getAllStatus())));
                                }
                                continue;
                            }
                            lore.add(s.replace("%name%", land.getName()).replace("%realx%", String.valueOf(land.getChunkX() << 4)).replace("%realz%", String.valueOf(land.getChunkZ() << 4)).replace("%members%", land.getMembersString()));
                        }
                        Icon icon = new Icon(new ItemStack(MultiListLands.this.plugin.getMaterialsManager().getGrass()));
                        icon.setName(MultiListLands.this.lm.getRawString("Commands.MultiListLands.gui.itemname").replace("%name%", land.getName()));
                        icon.setLore(lore);
                        icon.addClickAction(p -> {
                            boolean hasPerm = false;
                            for (String s : Sets.newHashSet((Iterable)MultiListLands.this.plugin.getConfig().getStringList("CommandSettings.Manage.permissions"))) {
                                if (!p.hasPermission(s)) continue;
                                hasPerm = true;
                                break;
                            }
                            if (hasPerm) {
                                ManageGui manageGUI = new ManageGui(MultiListLands.this.plugin, sender, landGui, land);
                                manageGUI.display();
                            }
                        });
                        landGui.addIcon(icon);
                    }
                    if (sender.isValid()) {
                        new BukkitRunnable(){

                            public void run() {
                                landGui.display();
                            }
                        }.runTask((Plugin)MultiListLands.this.plugin);
                    }
                } else {
                    ArrayList<String> formatted = new ArrayList<String>();
                    String segment = MultiListLands.this.lm.getRawString("Commands.MultiListLands.chat.segment");
                    for (IOwnedLand land : lands) {
                        formatted.add(segment.replace("%landname%", land.getName()).replace("%members%", land.getMembersString()));
                    }
                    String prev = MultiListLands.this.lm.getRawString("Commands.MultiListLands.chat.previous");
                    String next = MultiListLands.this.lm.getRawString("Commands.MultiListLands.chat.next");
                    final MultiPagedMessage message = new MultiPagedMessage(PrincepsLib.getCommandManager().getCommand(Landlordbase.class).getCommandString(ListLands.class), MultiListLands.this.plugin.getLangManager().getRawString("Commands.MultiListLands.gui.header").replace("%player%", target.getName()), MultiListLands.this.plugin.getConfig().getInt("CommandSettings.MultiListLands.landsPerPage"), formatted, prev, next, page);
                    if (sender.isValid()) {
                        new BukkitRunnable(){

                            public void run() {
                                MultiListLands.this.plugin.getUtilsManager().sendBasecomponent(sender, message.create());
                            }
                        }.runTask((Plugin)MultiListLands.this.plugin);
                    }
                }
            }
        }.runTaskAsynchronously((Plugin)this.plugin);
    }

    private String formatState(boolean bool) {
        if (!bool) {
            return this.lm.getRawString("Commands.Manage.AllowMob-spawning.toggleItem.deny");
        }
        return this.lm.getRawString("Commands.Manage.AllowMob-spawning.toggleItem.allow");
    }
}

