/*
 * Decompiled with CFR 0.152.
 */
package biz.princeps.landlord.commands.management;

import biz.princeps.landlord.api.ILandLord;
import biz.princeps.landlord.api.IOwnedLand;
import biz.princeps.landlord.api.IWorldGuardManager;
import biz.princeps.landlord.api.events.LandManageEvent;
import biz.princeps.landlord.commands.LandlordCommand;
import biz.princeps.landlord.guis.ManageGui;
import biz.princeps.landlord.multi.MultiMode;
import biz.princeps.lib.command.Arguments;
import biz.princeps.lib.command.Properties;
import biz.princeps.lib.exception.ArgumentsOutOfBoundsException;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;

public class Manage
extends LandlordCommand {
    private final IWorldGuardManager wg;

    public Manage(ILandLord plugin) {
        super(plugin, plugin.getConfig().getString("CommandSettings.Manage.name"), plugin.getConfig().getString("CommandSettings.Manage.usage"), Sets.newHashSet((Iterable)plugin.getConfig().getStringList("CommandSettings.Manage.permissions")), Sets.newHashSet((Iterable)plugin.getConfig().getStringList("CommandSettings.Manage.aliases")));
        this.wg = plugin.getWGManager();
    }

    @Override
    public void onCommand(Properties properties, Arguments arguments) {
        if (properties.isConsole()) {
            return;
        }
        String[] args = arguments.get();
        Player player = properties.getPlayer();
        if (args.length == 0 || args.length == 1 && !args[0].equals("setgreet") && !args[0].equals("setgreetall") && !args[0].equals("setfarewell") && !args[0].equals("setfarewellall")) {
            IOwnedLand land = args.length == 0 ? this.wg.getRegion(player.getLocation().getChunk()) : this.wg.getRegion(args[0]);
            if (land == null) {
                this.lm.sendMessage((CommandSender)player, this.lm.getString(player, "Commands.Manage.notOwnFreeLand"));
                return;
            }
            if (!land.isOwner(player.getUniqueId()) && !player.hasPermission("landlord.admin.manage")) {
                this.lm.sendMessage((CommandSender)player, this.lm.getString(player, "Commands.Manage.notOwn").replace("%owner%", land.getOwnersString()));
                return;
            }
            ManageGui gui = new ManageGui(this.plugin, player, land);
            gui.display();
        } else {
            switch (args[0]) {
                case "setgreetall": {
                    this.setGreet(player, args, new ArrayList<IOwnedLand>(this.wg.getRegions(player.getUniqueId())), 1);
                    break;
                }
                case "setfarewellall": {
                    this.setFarewell(player, args, new ArrayList<IOwnedLand>(this.wg.getRegions(player.getUniqueId())), 1);
                    break;
                }
                case "setgreet": {
                    this.setGreet(player, args, Collections.singletonList(this.wg.getRegion(player.getLocation())), 1);
                    break;
                }
                case "setfarewell": {
                    this.setFarewell(player, args, Collections.singletonList(this.wg.getRegion(player.getLocation())), 1);
                    break;
                }
                case "multisetgreet": {
                    try {
                        MultiMode mode = MultiMode.valueOf(arguments.get(1).toUpperCase());
                        int radius = arguments.getInt(2);
                        this.setGreet(player, args, new ArrayList<IOwnedLand>(mode.getLandsOf(radius, player.getLocation(), player.getUniqueId(), this.wg)), 3);
                    }
                    catch (ArgumentsOutOfBoundsException | IllegalArgumentException mode) {}
                    break;
                }
                case "multisetfarewell": {
                    try {
                        MultiMode mode = MultiMode.valueOf(arguments.get(1).toUpperCase());
                        int radius = arguments.getInt(2);
                        this.setFarewell(player, args, new ArrayList<IOwnedLand>(mode.getLandsOf(radius, player.getLocation(), player.getUniqueId(), this.wg)), 3);
                    }
                    catch (ArgumentsOutOfBoundsException | IllegalArgumentException mode) {}
                    break;
                }
                default: {
                    try {
                        IOwnedLand target = this.wg.getRegion(args[0]);
                        switch (args[1]) {
                            case "setgreet": {
                                this.setGreet(player, args, Collections.singletonList(target), 2);
                                break;
                            }
                            case "setfarewell": {
                                this.setFarewell(player, args, Collections.singletonList(target), 2);
                            }
                        }
                        break;
                    }
                    catch (IndexOutOfBoundsException e) {
                        this.lm.sendMessage((CommandSender)player, this.lm.getString(player, "Commands.manage.invalidArguments"));
                    }
                }
            }
        }
    }

    private void setGreet(Player player, String[] args, List<IOwnedLand> lands, int casy) {
        if (lands.size() == 0 || lands.get(0) == null) {
            this.lm.sendMessage((CommandSender)player, this.lm.getString(player, "Commands.Manage.notOwnFreeLand"));
            return;
        }
        StringBuilder sb = new StringBuilder();
        for (int i = casy; i < args.length; ++i) {
            sb.append(args[i]).append(" ");
        }
        String newmsg = ChatColor.translateAlternateColorCodes((char)'&', (String)sb.toString());
        if (newmsg.isEmpty()) {
            newmsg = this.lm.getRawString("Alerts.defaultGreeting");
        }
        newmsg = newmsg.replace("%owner%", player.getName());
        for (IOwnedLand region : lands) {
            LandManageEvent landManageEvent = new LandManageEvent(player, region, "GREET_MESSAGE", region.getGreetMessage(), newmsg);
            this.plugin.getServer().getPluginManager().callEvent((Event)landManageEvent);
            region.setGreetMessage(newmsg);
        }
        this.lm.sendMessage((CommandSender)player, this.lm.getString(player, "Commands.Manage.SetGreet.successful").replace("%msg%", newmsg));
    }

    private void setFarewell(Player player, String[] args, List<IOwnedLand> lands, int casy) {
        if (lands.size() == 0 || lands.get(0) == null) {
            this.lm.sendMessage((CommandSender)player, this.lm.getString(player, "Commands.Manage.notOwnFreeLand"));
            return;
        }
        StringBuilder sb = new StringBuilder();
        for (int i = casy; i < args.length; ++i) {
            sb.append(args[i]).append(" ");
        }
        String newmsg = ChatColor.translateAlternateColorCodes((char)'&', (String)sb.toString());
        if (newmsg.isEmpty()) {
            newmsg = this.lm.getRawString("Alerts.defaultFarewell");
        }
        newmsg = newmsg.replace("%owner%", player.getName());
        for (IOwnedLand region : lands) {
            LandManageEvent landManageEvent = new LandManageEvent(player, region, "FAREWELL_MESSAGE", region.getFarewellMessage(), newmsg);
            this.plugin.getServer().getPluginManager().callEvent((Event)landManageEvent);
            region.setFarewellMessage(newmsg);
        }
        this.lm.sendMessage((CommandSender)player, this.lm.getString(player, "Commands.Manage.SetFarewell.successful").replace("%msg%", newmsg));
    }
}

