/*
 * Decompiled with CFR 0.152.
 */
package biz.princeps.landlord.commands.management;

import biz.princeps.landlord.api.ILLFlag;
import biz.princeps.landlord.api.ILandLord;
import biz.princeps.landlord.api.IOwnedLand;
import biz.princeps.landlord.api.IPlayer;
import biz.princeps.landlord.api.ManageMode;
import biz.princeps.landlord.commands.LandlordCommand;
import biz.princeps.landlord.commands.Landlordbase;
import biz.princeps.landlord.guis.ManageGui;
import biz.princeps.landlord.guis.ManageGuiAll;
import biz.princeps.lib.PrincepsLib;
import biz.princeps.lib.chat.MultiPagedMessage;
import biz.princeps.lib.command.Arguments;
import biz.princeps.lib.command.Properties;
import biz.princeps.lib.exception.ArgumentsOutOfBoundsException;
import biz.princeps.lib.gui.MultiPagedGUI;
import biz.princeps.lib.gui.simple.Icon;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class ListLands
extends LandlordCommand {
    public ListLands(ILandLord plugin) {
        super(plugin, plugin.getConfig().getString("CommandSettings.ListLands.name"), plugin.getConfig().getString("CommandSettings.ListLands.usage"), Sets.newHashSet((Iterable)plugin.getConfig().getStringList("CommandSettings.ListLands.permissions")), Sets.newHashSet((Iterable)plugin.getConfig().getStringList("CommandSettings.ListLands.aliases")));
    }

    @Override
    public void onCommand(Properties properties, Arguments arguments) {
        if (properties.isPlayer()) {
            String target = null;
            int page = 0;
            try {
                switch (arguments.size()) {
                    case 2: {
                        target = arguments.get(0);
                        page = arguments.getInt(1);
                        break;
                    }
                    case 1: {
                        target = arguments.get(0);
                        break;
                    }
                }
            }
            catch (ArgumentsOutOfBoundsException ignored) {
                properties.sendUsage();
            }
            if (target == null) {
                this.onListLands(properties.getPlayer(), this.plugin.getPlayerManager().get(properties.getPlayer().getUniqueId()), page);
            } else if (properties.getPlayer().hasPermission("landlord.admin.list")) {
                String finalTarget = target;
                int finalPage = page;
                this.plugin.getPlayerManager().getOffline(target, lPlayer -> {
                    if (lPlayer == null) {
                        properties.getPlayer().sendMessage(this.lm.getString(properties.getPlayer(), "Commands.ListLands.noPlayer").replace("%player%", finalTarget));
                    } else {
                        this.onListLands(properties.getPlayer(), (IPlayer)lPlayer, finalPage);
                    }
                });
            }
        }
    }

    private void onListLands(final Player sender, final IPlayer target, final int page) {
        new BukkitRunnable(){

            public void run() {
                final ArrayList<IOwnedLand> lands = new ArrayList<IOwnedLand>(ListLands.this.plugin.getWGManager().getRegions(target.getUuid()));
                if (lands.size() == 0) {
                    ListLands.this.lm.sendMessage((CommandSender)sender, ListLands.this.plugin.getLangManager().getString("Commands.ListLands.noLands"));
                    return;
                }
                String mode = ListLands.this.plugin.getConfig().getString("CommandSettings.ListLands.mode");
                if (mode.equals("gui")) {
                    final MultiPagedGUI landGui = new MultiPagedGUI(ListLands.this.plugin, sender, 5, ListLands.this.plugin.getLangManager().getRawString("Commands.ListLands.gui.header").replace("%player%", target.getName())){

                        @Override
                        protected void generateStaticIcons() {
                            this.setIcon(52, new Icon(new ItemStack(Material.BEACON)).setName(ListLands.this.lm.getRawString("Commands.ListLands.gui.manageAll")).addClickAction(p -> {
                                ManageGuiAll manageGUIAll = new ManageGuiAll(ListLands.this.plugin, sender, this, (List<IOwnedLand>)lands, ManageMode.ALL, null, -1);
                                manageGUIAll.display();
                            }));
                        }
                    };
                    for (IOwnedLand land : lands) {
                        List<String> loreRaw = ListLands.this.plugin.getLangManager().getStringList("Commands.ListLands.gui.lore");
                        ArrayList<String> lore = new ArrayList<String>();
                        for (String s : loreRaw) {
                            if (s.contains("%flags%")) {
                                String flagFormat = ListLands.this.lm.getRawString("Commands.ListLands.gui.flagformat");
                                for (ILLFlag flag : land.getFlags()) {
                                    lore.add(flagFormat.replace("%flagname%", flag.getName()).replace("%friend%", ListLands.this.formatState(flag.getFriendStatus())).replace("%all%", ListLands.this.formatState(flag.getAllStatus())));
                                }
                                continue;
                            }
                            lore.add(s.replace("%name%", land.getName()).replace("%realx%", String.valueOf(land.getChunkX() << 4)).replace("%realz%", String.valueOf(land.getChunkZ() << 4)).replace("%members%", land.getMembersString()));
                        }
                        Icon icon = new Icon(new ItemStack(ListLands.this.plugin.getMaterialsManager().getGrass()));
                        icon.setName(ListLands.this.lm.getRawString("Commands.ListLands.gui.itemname").replace("%name%", land.getName()));
                        icon.setLore(lore);
                        icon.addClickAction(p -> {
                            boolean hasPerm = false;
                            for (String s : Sets.newHashSet((Iterable)ListLands.this.plugin.getConfig().getStringList("CommandSettings.Manage.permissions"))) {
                                if (!p.hasPermission(s)) continue;
                                hasPerm = true;
                                break;
                            }
                            if (hasPerm) {
                                ManageGui manageGUI = new ManageGui(ListLands.this.plugin, sender, landGui, land);
                                manageGUI.display();
                            }
                        });
                        landGui.addIcon(icon);
                    }
                    if (sender.isValid()) {
                        new BukkitRunnable(){

                            public void run() {
                                landGui.display();
                            }
                        }.runTask((Plugin)ListLands.this.plugin);
                    }
                } else {
                    ArrayList<String> formatted = new ArrayList<String>();
                    String segment = ListLands.this.lm.getRawString("Commands.ListLands.chat.segment");
                    for (IOwnedLand land : lands) {
                        formatted.add(segment.replace("%landname%", land.getName()).replace("%members%", land.getMembersString()));
                    }
                    String prev = ListLands.this.lm.getRawString("Commands.ListLands.chat.previous");
                    String next = ListLands.this.lm.getRawString("Commands.ListLands.chat.next");
                    final MultiPagedMessage message = new MultiPagedMessage(PrincepsLib.getCommandManager().getCommand(Landlordbase.class).getCommandString(ListLands.class), ListLands.this.plugin.getLangManager().getRawString("Commands.ListLands.gui.header").replace("%player%", target.getName()), ListLands.this.plugin.getConfig().getInt("CommandSettings.ListLands.landsPerPage"), formatted, prev, next, page);
                    if (sender.isValid()) {
                        new BukkitRunnable(){

                            public void run() {
                                ListLands.this.plugin.getUtilsManager().sendBasecomponent(sender, message.create());
                            }
                        }.runTask((Plugin)ListLands.this.plugin);
                    }
                }
            }
        }.runTaskAsynchronously((Plugin)this.plugin);
    }

    private String formatState(boolean bool) {
        if (!bool) {
            return this.lm.getRawString("Commands.Manage.AllowMob-spawning.toggleItem.deny");
        }
        return this.lm.getRawString("Commands.Manage.AllowMob-spawning.toggleItem.allow");
    }
}

