/*
 * Decompiled with CFR 0.152.
 */
package biz.princeps.landlord.commands.management;

import biz.princeps.landlord.api.ILandLord;
import biz.princeps.landlord.api.IOwnedLand;
import biz.princeps.landlord.api.IWorldGuardManager;
import biz.princeps.landlord.api.Options;
import biz.princeps.landlord.commands.LandlordCommand;
import biz.princeps.lib.command.Arguments;
import biz.princeps.lib.command.Properties;
import com.google.common.collect.Sets;
import java.time.LocalDateTime;
import java.util.Iterator;
import java.util.List;
import org.bukkit.Chunk;
import org.bukkit.OfflinePlayer;
import org.bukkit.Particle;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class Info
extends LandlordCommand {
    private final String free;
    private final String owned;
    private final String advertised;
    private final String inactive;
    private final IWorldGuardManager wg;

    public Info(ILandLord plugin) {
        super(plugin, plugin.getConfig().getString("CommandSettings.Info.name"), plugin.getConfig().getString("CommandSettings.Info.usage"), Sets.newHashSet((Iterable)plugin.getConfig().getStringList("CommandSettings.Info.permissions")), Sets.newHashSet((Iterable)plugin.getConfig().getStringList("CommandSettings.Info.aliases")));
        this.wg = plugin.getWGManager();
        List<String> ownedList = plugin.getLangManager().getStringList("Commands.Info.owned");
        StringBuilder sb = new StringBuilder();
        Iterator<String> it = ownedList.iterator();
        while (it.hasNext()) {
            sb.append(it.next());
            if (!it.hasNext()) continue;
            sb.append("\n");
        }
        this.owned = sb.toString();
        List<String> freeList = plugin.getLangManager().getStringList("Commands.Info.free");
        sb = new StringBuilder();
        it = freeList.iterator();
        while (it.hasNext()) {
            sb.append(it.next());
            if (!it.hasNext()) continue;
            sb.append("\n");
        }
        this.free = sb.toString();
        List<String> advertisedList = plugin.getLangManager().getStringList("Commands.Info.advertised");
        sb = new StringBuilder();
        it = advertisedList.iterator();
        while (it.hasNext()) {
            sb.append(it.next());
            if (!it.hasNext()) continue;
            sb.append("\n");
        }
        this.advertised = sb.toString();
        List<String> inactiveList = plugin.getLangManager().getStringList("Commands.Info.inactive");
        sb = new StringBuilder();
        it = inactiveList.iterator();
        while (it.hasNext()) {
            sb.append(it.next());
            if (!it.hasNext()) continue;
            sb.append("\n");
        }
        this.inactive = sb.toString();
    }

    private String replaceInMessage(String original, String landID, String owner, String member, String lastseen, String price) {
        return original.replace("%landid%", landID).replace("%owner%", owner).replace("%member%", member.isEmpty() ? "-" : member).replace("%lastseen%", lastseen).replace("%price%", price);
    }

    @Override
    public void onCommand(Properties properties, Arguments arguments) {
        if (properties.isConsole()) {
            return;
        }
        Player player = properties.getPlayer();
        if (this.isDisabledWorld(player)) {
            return;
        }
        Chunk chunk = player.getLocation().getChunk();
        IOwnedLand land = this.wg.getRegion(chunk);
        if (land != null) {
            this.plugin.getPlayerManager().getOffline(land.getOwner(), owner -> {
                String lastseen;
                String owners = land.getOwnersString();
                String friends = land.getMembersString();
                LocalDateTime lastSeenDate = null;
                OfflinePlayer op = this.plugin.getServer().getOfflinePlayer(land.getOwner());
                if (op.isOnline()) {
                    lastseen = this.lm.getRawString("Commands.Info.online");
                } else if (owner != null) {
                    lastseen = owner.getLastSeen().toString();
                    lastSeenDate = owner.getLastSeen();
                } else {
                    lastseen = this.lm.getRawString("Commands.Info.noLastSeen");
                }
                if (this.plugin.getPlayerManager().isInactive(lastSeenDate)) {
                    this.lm.sendMessage((CommandSender)player, this.replaceInMessage(this.inactive, land.getName(), owners, friends, lastseen, this.plugin.getVaultManager().format(this.plugin.getCostManager().calculateCost(player.getUniqueId()))));
                    if (this.plugin.getConfig().getBoolean("Particles.info")) {
                        land.highlightLand(player, Particle.valueOf((String)this.plugin.getConfig().getString("Particles.info.inactive").toUpperCase()));
                    }
                    return;
                }
                if (land.getPrice() != -1.0) {
                    this.lm.sendMessage((CommandSender)player, this.replaceInMessage(this.advertised, land.getName(), owners, friends, lastseen, this.plugin.getVaultManager().format(land.getPrice())));
                } else {
                    this.lm.sendMessage((CommandSender)player, this.replaceInMessage(this.owned, land.getName(), owners, friends, lastseen, ""));
                }
                if (this.plugin.getConfig().getBoolean("Particles.info")) {
                    land.highlightLand(player, Particle.valueOf((String)this.plugin.getConfig().getString("Particles.info.claimed").toUpperCase()));
                }
            });
        } else {
            if (!this.plugin.getConfig().getBoolean("CommandSettings.Claim.allowOverlap", false) && !this.wg.canClaim(player, chunk)) {
                this.lm.sendMessage((CommandSender)player, this.lm.getString(player, "Commands.Claim.notAllowed"));
                return;
            }
            this.lm.sendMessage((CommandSender)player, this.replaceInMessage(this.free, this.wg.getLandName(chunk), "", "", "", Options.isVaultEnabled() ? this.plugin.getVaultManager().format(this.plugin.getCostManager().calculateCost(player.getUniqueId())) : ""));
            if (this.plugin.getConfig().getBoolean("Particles.info")) {
                this.wg.highlightLand(chunk, player, Particle.valueOf((String)this.plugin.getConfig().getString("Particles.info.unclaimed").toUpperCase()), 4, false);
            }
        }
    }
}

