/*
 * Decompiled with CFR 0.152.
 */
package biz.princeps.landlord.commands.homes;

import LandLord.landlord.paperlib.PaperLib;
import biz.princeps.landlord.api.ILandLord;
import biz.princeps.landlord.api.Options;
import biz.princeps.landlord.commands.LandlordCommand;
import biz.princeps.landlord.commands.Landlordbase;
import biz.princeps.landlord.commands.homes.SetHome;
import biz.princeps.lib.PrincepsLib;
import biz.princeps.lib.command.Arguments;
import biz.princeps.lib.command.Properties;
import biz.princeps.lib.exception.ArgumentsOutOfBoundsException;
import biz.princeps.lib.util.CommandDelayManager;
import com.google.common.collect.Sets;
import net.md_5.bungee.api.chat.ClickEvent;
import net.md_5.bungee.api.chat.ComponentBuilder;
import org.bukkit.Location;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class Home
extends LandlordCommand {
    public Home(ILandLord plugin) {
        super(plugin, plugin.getConfig().getString("CommandSettings.Home.name"), plugin.getConfig().getString("CommandSettings.Home.usage"), Sets.newHashSet((Iterable)plugin.getConfig().getStringList("CommandSettings.Home.permissions")), Sets.newHashSet((Iterable)plugin.getConfig().getStringList("CommandSettings.Home.aliases")));
        CommandDelayManager delayManager = new CommandDelayManager(this.lm.getString("Commands.Home.dontMove"), this.lm.getString("Commands.Home.youMoved"), this.lm.getRawString("Commands.Home.countdown"), plugin.getConfig().getBoolean("Homes.spawnParticles"));
        int delay = plugin.getConfig().getInt("Homes.delay");
        for (String mainAlias : plugin.getConfig().getStringList("CommandSettings.Main.aliases")) {
            for (String homeAlias : plugin.getConfig().getStringList("CommandSettings.Home.aliases")) {
                delayManager.delayCommand("/" + mainAlias + " " + homeAlias, delay);
            }
            delayManager.delayCommand("/" + mainAlias + " " + plugin.getConfig().getString("CommandSettings.Home.name"), delay);
        }
    }

    @Override
    public void onCommand(Properties properties, Arguments arguments) {
        if (properties.isPlayer()) {
            String target;
            try {
                target = arguments.get(0);
            }
            catch (ArgumentsOutOfBoundsException e) {
                target = "own";
            }
            this.onHome(properties, target);
        }
    }

    private void onHome(Properties props, final String targetPlayer) {
        final Player player = props.getPlayer();
        if (!Options.enabled_homes()) {
            this.lm.sendMessage((CommandSender)player, this.lm.getString(player, "Commands.SetHome.disabled"));
            return;
        }
        if (targetPlayer.equals("own")) {
            Location toGo = this.plugin.getPlayerManager().get(player.getUniqueId()).getHome();
            this.teleport(toGo, player, player.getName());
        } else {
            if (!player.hasPermission("landlord.player.homeother")) {
                this.lm.sendMessage((CommandSender)player, this.lm.getString(player, "noPermissions"));
                return;
            }
            this.plugin.getPlayerManager().getOffline(targetPlayer, offline -> {
                if (offline == null) {
                    this.lm.sendMessage((CommandSender)player, this.lm.getString(player, "Commands.Home.otherNoHome"));
                } else {
                    final Location home = offline.getHome();
                    if (home == null) {
                        this.lm.sendMessage((CommandSender)player, this.lm.getString(player, "Commands.Home.otherNoHome"));
                        return;
                    }
                    new BukkitRunnable(){

                        public void run() {
                            Home.this.teleport(home, player, targetPlayer);
                        }
                    }.runTask((Plugin)this.plugin);
                }
            });
        }
    }

    private void teleport(Location toGo, Player player, String playerHome) {
        double cost = this.plugin.getConfig().getDouble("Homes.teleportCost");
        if (Options.isVaultEnabled() && !this.plugin.getVaultManager().hasBalance(player, cost)) {
            this.lm.sendMessage((CommandSender)player, this.lm.getString(player, "Commands.Home.notEnoughMoney").replace("%cost%", this.plugin.getVaultManager().format(cost)));
            return;
        }
        if (toGo == null) {
            ComponentBuilder builder = new ComponentBuilder(this.lm.getString(player, "Commands.Home.noHome"));
            builder.event(new ClickEvent(ClickEvent.Action.RUN_COMMAND, PrincepsLib.getCommandManager().getCommand(Landlordbase.class).getCommandString(SetHome.class)));
            this.plugin.getUtilsManager().sendBasecomponent(player, builder.create());
            return;
        }
        if (cost > 0.0 && Options.isVaultEnabled()) {
            this.plugin.getVaultManager().take(player, cost);
            this.lm.sendMessage((CommandSender)player, this.lm.getString(player, "Commands.Home.costing").replace("%cost%", this.plugin.getVaultManager().format(cost)));
        }
        PaperLib.teleportAsync((Entity)player, toGo).thenRun(() -> this.lm.sendMessage((CommandSender)player, this.lm.getString(player, "Commands.Home.welcomeHome").replace("%player%", playerHome)));
    }
}

