/*
 * Decompiled with CFR 0.152.
 */
package biz.princeps.landlord.commands.friends;

import biz.princeps.landlord.api.ILandLord;
import biz.princeps.landlord.api.IOwnedLand;
import biz.princeps.landlord.api.events.LandManageEvent;
import biz.princeps.landlord.commands.LandlordCommand;
import biz.princeps.lib.command.Arguments;
import biz.princeps.lib.command.Properties;
import biz.princeps.lib.exception.ArgumentsOutOfBoundsException;
import com.google.common.collect.Sets;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class Unfriend
extends LandlordCommand {
    public Unfriend(ILandLord plugin) {
        super(plugin, plugin.getConfig().getString("CommandSettings.RemoveFriend.name"), plugin.getConfig().getString("CommandSettings.RemoveFriend.usage"), Sets.newHashSet((Iterable)plugin.getConfig().getStringList("CommandSettings.RemoveFriend.permissions")), Sets.newHashSet((Iterable)plugin.getConfig().getStringList("CommandSettings.RemoveFriend.aliases")));
    }

    @Override
    public void onCommand(Properties properties, Arguments arguments) {
        if (properties.isConsole()) {
            return;
        }
        Player player = properties.getPlayer();
        if (arguments.size() == 0) {
            this.lm.sendMessage((CommandSender)player, this.lm.getString(player, "Commands.Addfriend.noPlayer").replace("%players%", "?"));
            return;
        }
        try {
            IOwnedLand targetLand;
            String targetPlayer;
            if (arguments.size() == 1) {
                targetPlayer = arguments.get(0);
                targetLand = this.plugin.getWGManager().getRegion(player.getLocation());
            } else {
                targetPlayer = arguments.get(0);
                targetLand = this.plugin.getWGManager().getRegion(arguments.get(1));
            }
            this.onUnfriend(player, targetPlayer, targetLand);
        }
        catch (ArgumentsOutOfBoundsException e) {
            properties.sendUsage();
        }
    }

    private void onUnfriend(final Player player, String playerName, final IOwnedLand land) {
        if (this.isDisabledWorld(player)) {
            return;
        }
        if (land != null) {
            if (!land.isOwner(player.getUniqueId()) && !player.hasPermission("landlord.admin.modifyfriends")) {
                this.lm.sendMessage((CommandSender)player, this.lm.getString(player, "Commands.Unfriend.notOwn").replace("%owner%", land.getOwnersString()));
                return;
            }
            this.plugin.getPlayerManager().getOffline(playerName, offline -> {
                if (offline == null) {
                    this.lm.sendMessage((CommandSender)player, this.lm.getString(player, "Commands.Unfriend.noPlayer").replace("%players%", playerName));
                } else if (land.getFriends().contains(offline.getUuid())) {
                    final String old = land.getMembersString();
                    land.removeFriend(offline.getUuid());
                    new BukkitRunnable(){

                        public void run() {
                            LandManageEvent landManageEvent = new LandManageEvent(player, land, "FRIENDS", old, land.getMembersString());
                            Unfriend.this.plugin.getServer().getPluginManager().callEvent((Event)landManageEvent);
                        }
                    }.runTask((Plugin)this.plugin);
                    this.lm.sendMessage((CommandSender)player, this.lm.getString(player, "Commands.Unfriend.success").replace("%players%", playerName));
                    new BukkitRunnable(){

                        public void run() {
                            Unfriend.this.plugin.getMapManager().updateAll();
                        }
                    }.runTaskLater((Plugin)this.plugin, 60L);
                } else {
                    this.lm.sendMessage((CommandSender)player, this.lm.getString(player, "Commands.UnfriendAll.noFriend").replace("%player%", playerName));
                }
            });
        }
    }
}

