/*
 * Decompiled with CFR 0.152.
 */
package biz.princeps.landlord.commands.friends;

import biz.princeps.landlord.api.ILandLord;
import biz.princeps.landlord.api.IOwnedLand;
import biz.princeps.landlord.api.IPlayer;
import biz.princeps.landlord.api.IWorldGuardManager;
import biz.princeps.landlord.api.events.LandManageEvent;
import biz.princeps.landlord.commands.LandlordCommand;
import biz.princeps.landlord.multi.MultiMode;
import biz.princeps.lib.command.Arguments;
import biz.princeps.lib.command.Properties;
import biz.princeps.lib.exception.ArgumentsOutOfBoundsException;
import com.google.common.collect.Sets;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class MultiRemovefriend
extends LandlordCommand {
    private final IWorldGuardManager wg;

    public MultiRemovefriend(ILandLord plugin) {
        super(plugin, plugin.getConfig().getString("CommandSettings.MultiRemovefriend.name"), plugin.getConfig().getString("CommandSettings.MultiRemovefriend.usage"), Sets.newHashSet((Iterable)plugin.getConfig().getStringList("CommandSettings.MultiRemovefriend.permissions")), Sets.newHashSet((Iterable)plugin.getConfig().getStringList("CommandSettings.MultiRemovefriend.aliases")));
        this.wg = plugin.getWGManager();
    }

    @Override
    public void onCommand(Properties properties, Arguments arguments) {
        String name;
        int radius;
        MultiMode mode;
        if (properties.isConsole()) {
            properties.sendMessage("Player command only!");
            return;
        }
        if (arguments.size() != 3) {
            properties.sendUsage();
            return;
        }
        try {
            mode = MultiMode.valueOf(arguments.get(0).toUpperCase());
            radius = arguments.getInt(1);
            name = arguments.get(2);
        }
        catch (ArgumentsOutOfBoundsException | IllegalArgumentException ex) {
            properties.sendUsage();
            return;
        }
        this.onUnfriend(properties.getPlayer(), mode, radius, name);
    }

    private void onUnfriend(final Player player, final MultiMode mode, final int radius, String name) {
        if (this.isDisabledWorld(player)) {
            return;
        }
        if (name == null || name.isEmpty()) {
            this.lm.sendMessage((CommandSender)player, this.lm.getString(player, "Commands.MultiUnfriend.noPlayer").replace("%players%", "?"));
            return;
        }
        this.plugin.getPlayerManager().getOffline(name, offline -> {
            if (offline == null) {
                this.lm.sendMessage((CommandSender)player, this.lm.getString(player, "Commands.MultiUnfriend.noPlayer").replace("%players%", name));
            } else {
                new BukkitRunnable((IPlayer)offline, name){
                    final /* synthetic */ IPlayer val$offline;
                    final /* synthetic */ String val$name;
                    {
                        this.val$offline = iPlayer;
                        this.val$name = string;
                    }

                    public void run() {
                        int count = 0;
                        for (final IOwnedLand ol : mode.getLandsOf(radius, player.getLocation(), player.getUniqueId(), MultiRemovefriend.this.wg)) {
                            if (!ol.isFriend(this.val$offline.getUuid())) continue;
                            final String oldvalue = ol.getMembersString();
                            ol.removeFriend(this.val$offline.getUuid());
                            ++count;
                            new BukkitRunnable(){

                                public void run() {
                                    LandManageEvent landManageEvent = new LandManageEvent(player, ol, "FRIENDS", oldvalue, ol.getMembersString());
                                    MultiRemovefriend.this.plugin.getServer().getPluginManager().callEvent((Event)landManageEvent);
                                }
                            }.runTask((Plugin)MultiRemovefriend.this.plugin);
                        }
                        if (count > 0) {
                            MultiRemovefriend.this.lm.sendMessage((CommandSender)player, MultiRemovefriend.this.lm.getString(player, "Commands.MultiUnfriend.success").replace("%count%", String.valueOf(count)).replace("%players%", this.val$name));
                            new BukkitRunnable(){

                                public void run() {
                                    MultiRemovefriend.this.plugin.getMapManager().updateAll();
                                }
                            }.runTask((Plugin)MultiRemovefriend.this.plugin);
                        } else {
                            MultiRemovefriend.this.lm.sendMessage((CommandSender)player, MultiRemovefriend.this.lm.getString(player, "Commands.MultiUnfriend.noFriend").replace("%player%", this.val$name));
                        }
                    }
                }.runTaskAsynchronously((Plugin)this.plugin);
            }
        });
    }
}

