/*
 * Decompiled with CFR 0.152.
 */
package biz.princeps.landlord.commands.friends;

import biz.princeps.landlord.api.ILandLord;
import biz.princeps.landlord.api.IOwnedLand;
import biz.princeps.landlord.api.IWorldGuardManager;
import biz.princeps.landlord.commands.LandlordCommand;
import biz.princeps.lib.command.Arguments;
import biz.princeps.lib.command.Properties;
import com.google.common.collect.Sets;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class ListFriends
extends LandlordCommand {
    private final IWorldGuardManager wg;

    public ListFriends(ILandLord plugin) {
        super(plugin, plugin.getConfig().getString("CommandSettings.Listfriends.name"), plugin.getConfig().getString("CommandSettings.Listfriends.usage"), Sets.newHashSet((Iterable)plugin.getConfig().getStringList("CommandSettings.Listfriends.permissions")), Sets.newHashSet((Iterable)plugin.getConfig().getStringList("CommandSettings.Listfriends.aliases")));
        this.wg = plugin.getWGManager();
    }

    @Override
    public void onCommand(Properties properties, Arguments arguments) {
        if (properties.isPlayer()) {
            IOwnedLand region;
            String[] args = arguments.get();
            String landname = args.length == 0 ? ((region = this.wg.getRegion(properties.getPlayer().getLocation())) != null ? region.getName() : null) : args[0];
            this.onListFriends(properties.getPlayer(), landname);
        }
    }

    private void onListFriends(Player player, String landname) {
        if (this.isDisabledWorld(player)) {
            return;
        }
        if (landname == null) {
            this.lm.sendMessage((CommandSender)player, this.lm.getString(player, "Commands.Listfriends.freeLand"));
            return;
        }
        if (!this.wg.isLLRegion(landname)) {
            this.lm.sendMessage((CommandSender)player, this.lm.getString(player, "Commands.Listfriends.invalidGeneral"));
            return;
        }
        IOwnedLand land = this.wg.getRegion(landname);
        if (land == null) {
            this.lm.sendMessage((CommandSender)player, this.lm.getString(player, "Commands.Listfriends.freeLand"));
            return;
        }
        if (land.getFriends().size() > 0) {
            this.lm.sendMessage((CommandSender)player, this.lm.getString(player, "Commands.Listfriends.friends").replace("%friends%", land.getMembersString()));
        } else {
            this.lm.sendMessage((CommandSender)player, this.lm.getString(player, "Commands.Listfriends.noFriends"));
        }
    }
}

