/*
 * Decompiled with CFR 0.152.
 */
package biz.princeps.landlord.commands.friends;

import biz.princeps.landlord.api.ILandLord;
import biz.princeps.landlord.api.IOwnedLand;
import biz.princeps.landlord.api.events.LandManageEvent;
import biz.princeps.landlord.commands.LandlordCommand;
import biz.princeps.lib.command.Arguments;
import biz.princeps.lib.command.Properties;
import biz.princeps.lib.exception.ArgumentsOutOfBoundsException;
import com.google.common.collect.Sets;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class Addfriend
extends LandlordCommand {
    public Addfriend(ILandLord plugin) {
        super(plugin, plugin.getConfig().getString("CommandSettings.Addfriend.name"), plugin.getConfig().getString("CommandSettings.Addfriend.usage"), Sets.newHashSet((Iterable)plugin.getConfig().getStringList("CommandSettings.Addfriend.permissions")), Sets.newHashSet((Iterable)plugin.getConfig().getStringList("CommandSettings.Addfriend.aliases")));
    }

    @Override
    public void onCommand(Properties properties, Arguments arguments) {
        if (properties.isConsole()) {
            return;
        }
        try {
            this.onAddfriend(properties.getPlayer(), arguments.get(0));
        }
        catch (ArgumentsOutOfBoundsException e) {
            this.onAddfriend(properties.getPlayer(), null);
        }
    }

    private void onAddfriend(final Player player, String playerName) {
        if (this.isDisabledWorld(player)) {
            return;
        }
        final IOwnedLand land = this.plugin.getWGManager().getRegion(player.getLocation());
        if (land != null) {
            if (!land.isOwner(player.getUniqueId()) && !player.hasPermission("landlord.admin.modifyfriends")) {
                this.lm.sendMessage((CommandSender)player, this.lm.getString(player, "Commands.Addfriend.notOwn").replace("%owner%", land.getOwnersString()));
                return;
            }
            if (playerName == null) {
                this.lm.sendMessage((CommandSender)player, this.lm.getString(player, "Commands.Addfriend.noPlayer").replace("%players%", "?"));
                return;
            }
            this.plugin.getPlayerManager().getOffline(playerName, offline -> {
                if (offline == null) {
                    this.lm.sendMessage((CommandSender)player, this.lm.getString(player, "Commands.Addfriend.noPlayer").replace("%players%", playerName));
                } else if (!land.isOwner(offline.getUuid())) {
                    final String oldFriends = land.getMembersString();
                    land.addFriend(offline.getUuid());
                    new BukkitRunnable(){

                        public void run() {
                            LandManageEvent landManageEvent = new LandManageEvent(player, land, "FRIENDS", oldFriends, land.getMembersString());
                            Addfriend.this.plugin.getServer().getPluginManager().callEvent((Event)landManageEvent);
                        }
                    }.runTask((Plugin)this.plugin);
                    this.lm.sendMessage((CommandSender)player, this.lm.getString(player, "Commands.Addfriend.success").replace("%players%", playerName));
                    new BukkitRunnable(){

                        public void run() {
                            Addfriend.this.plugin.getMapManager().updateAll();
                        }
                    }.runTaskLater((Plugin)this.plugin, 60L);
                } else {
                    this.lm.sendMessage((CommandSender)player, this.lm.getString(player, "Commands.Addfriend.alreadyOwn"));
                }
            });
        }
    }
}

