/*
 * Decompiled with CFR 0.152.
 */
package biz.princeps.landlord.commands.claiming.adv;

import biz.princeps.landlord.api.ILandLord;
import biz.princeps.landlord.api.IOwnedLand;
import biz.princeps.landlord.api.IWorldGuardManager;
import biz.princeps.landlord.api.Options;
import biz.princeps.landlord.commands.LandlordCommand;
import biz.princeps.lib.command.Arguments;
import biz.princeps.lib.command.Properties;
import biz.princeps.lib.exception.ArgumentsOutOfBoundsException;
import com.google.common.collect.Sets;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class Advertise
extends LandlordCommand {
    private final IWorldGuardManager wg;

    public Advertise(ILandLord plugin) {
        super(plugin, plugin.getConfig().getString("CommandSettings.Advertise.name"), plugin.getConfig().getString("CommandSettings.Advertise.usage"), Sets.newHashSet((Iterable)plugin.getConfig().getStringList("CommandSettings.Advertise.permissions")), Sets.newHashSet((Iterable)plugin.getConfig().getStringList("CommandSettings.Advertise.aliases")));
        this.wg = plugin.getWGManager();
    }

    @Override
    public void onCommand(Properties properties, Arguments arguments) {
        if (properties.isConsole()) {
            return;
        }
        if (!Options.isVaultEnabled()) {
            return;
        }
        try {
            double price;
            String landname = "this";
            if (arguments.size() > 1) {
                landname = arguments.get(0);
                price = arguments.getDouble(1);
            } else {
                price = arguments.getDouble(0);
            }
            this.onAdvertise(properties.getPlayer(), landname, price);
        }
        catch (ArgumentsOutOfBoundsException e) {
            properties.sendUsage();
        }
    }

    private void onAdvertise(Player player, String landname, double price) {
        IOwnedLand iOwnedLand = landname.equals("this") ? this.wg.getRegion(player.getLocation()) : this.wg.getRegion(landname);
        if (iOwnedLand == null) {
            this.lm.sendMessage((CommandSender)player, this.lm.getString(player, "Commands.Advertise.notOwnFreeLand"));
            return;
        }
        if (this.isDisabledWorld(player, iOwnedLand.getWorld())) {
            return;
        }
        if (!iOwnedLand.isOwner(player.getUniqueId())) {
            this.lm.sendMessage((CommandSender)player, this.lm.getString(player, "Commands.Advertise.notOwn").replace("%owner%", iOwnedLand.getOwnersString()));
            return;
        }
        iOwnedLand.setPrice(price);
        this.lm.sendMessage((CommandSender)player, this.lm.getString(player, "Commands.Advertise.success").replace("%landname%", iOwnedLand.getName()).replace("%price%", price + ""));
    }
}

