/*
 * Decompiled with CFR 0.152.
 */
package biz.princeps.landlord.commands.claiming;

import biz.princeps.landlord.api.ILandLord;
import biz.princeps.landlord.api.IMultiTaskManager;
import biz.princeps.landlord.api.IOwnedLand;
import biz.princeps.landlord.api.ManageMode;
import biz.princeps.landlord.commands.LandlordCommand;
import biz.princeps.landlord.multi.MultiUnclaimTask;
import biz.princeps.lib.PrincepsLib;
import biz.princeps.lib.command.Arguments;
import biz.princeps.lib.command.Properties;
import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class UnclaimAll
extends LandlordCommand {
    private final IMultiTaskManager multiTaskManager;

    public UnclaimAll(ILandLord plugin) {
        super(plugin, plugin.getConfig().getString("CommandSettings.UnclaimAll.name"), plugin.getConfig().getString("CommandSettings.UnclaimAll.usage"), Sets.newHashSet((Iterable)plugin.getConfig().getStringList("CommandSettings.UnclaimAll.permissions")), Sets.newHashSet((Iterable)plugin.getConfig().getStringList("CommandSettings.UnclaimAll.aliases")));
        this.multiTaskManager = plugin.getMultiTaskManager();
    }

    @Override
    public void onCommand(Properties properties, Arguments arguments) {
        List<World> worlds;
        if (properties.isConsole()) {
            return;
        }
        Player player = properties.getPlayer();
        if (arguments.size() == 1) {
            String worldName = arguments.get(0);
            World world = this.plugin.getServer().getWorld(worldName);
            if (world == null) {
                this.lm.sendMessage((CommandSender)player, this.lm.getString(player, "Commands.UnclaimAll.invalidWorld"));
                return;
            }
            worlds = Collections.singletonList(world);
        } else {
            worlds = this.plugin.getServer().getWorlds();
        }
        if (this.plugin.getConfig().getBoolean("ConfirmationDialog.onUnclaimAll")) {
            String guiMsg = this.lm.getRawString("Commands.UnclaimAll.confirm");
            PrincepsLib.getConfirmationManager().drawGUI(player, guiMsg, p -> {
                this.performUnclaimAll(player, worlds);
                player.closeInventory();
            }, p2 -> player.closeInventory(), null);
        } else {
            this.performUnclaimAll(player, worlds);
        }
    }

    public void performUnclaimAll(Player player, List<World> worlds) {
        for (World world : worlds) {
            if (this.isDisabledWorld(world)) continue;
            HashSet<IOwnedLand> playerLands = new HashSet<IOwnedLand>(this.plugin.getWGManager().getRegions(player.getUniqueId(), world));
            if (playerLands.isEmpty()) {
                this.lm.sendMessage((CommandSender)player, this.lm.getString(player, "Commands.UnclaimAll.notOwnFreeLand") + " (" + world.getName() + ")");
                continue;
            }
            this.multiTaskManager.enqueueTask(new MultiUnclaimTask(this.plugin, player, playerLands, world, ManageMode.ALL));
        }
    }
}

