/*
 * Decompiled with CFR 0.152.
 */
package biz.princeps.landlord.commands.claiming;

import biz.princeps.landlord.api.ILandLord;
import biz.princeps.landlord.api.IOwnedLand;
import biz.princeps.landlord.api.IPlayer;
import biz.princeps.landlord.api.IWorldGuardManager;
import biz.princeps.landlord.api.Options;
import biz.princeps.landlord.api.events.LandUnclaimEvent;
import biz.princeps.landlord.commands.LandlordCommand;
import biz.princeps.lib.PrincepsLib;
import biz.princeps.lib.command.Arguments;
import biz.princeps.lib.command.Properties;
import biz.princeps.lib.exception.ArgumentsOutOfBoundsException;
import com.google.common.collect.Sets;
import org.bukkit.Location;
import org.bukkit.Particle;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;

public class Unclaim
extends LandlordCommand {
    private final IWorldGuardManager wg;

    public Unclaim(ILandLord plugin) {
        super(plugin, plugin.getConfig().getString("CommandSettings.Unclaim.name"), plugin.getConfig().getString("CommandSettings.Unclaim.usage"), Sets.newHashSet((Iterable)plugin.getConfig().getStringList("CommandSettings.Unclaim.permissions")), Sets.newHashSet((Iterable)plugin.getConfig().getStringList("CommandSettings.Unclaim.aliases")));
        this.wg = plugin.getWGManager();
    }

    @Override
    public void onCommand(Properties properties, Arguments arguments) {
        if (properties.isPlayer()) {
            try {
                this.onUnclaim(properties.getPlayer(), arguments.get(0));
            }
            catch (ArgumentsOutOfBoundsException e) {
                this.onUnclaim(properties.getPlayer(), "null");
            }
        }
    }

    public void onUnclaim(Player player, String chunkname) {
        IOwnedLand ol;
        if (chunkname.equals("null")) {
            Location location = player.getLocation();
            ol = this.wg.getRegion(location);
            chunkname = this.wg.getLandName(location);
        } else {
            if (!this.wg.isLLRegion(chunkname)) {
                this.lm.sendMessage((CommandSender)player, this.lm.getString(player, "Commands.Unclaim.notOwnFreeLand"));
                return;
            }
            ol = this.wg.getRegion(chunkname);
        }
        if (this.isDisabledWorld(player, this.wg.getWorld(chunkname))) {
            return;
        }
        if (ol == null) {
            this.lm.sendMessage((CommandSender)player, this.lm.getString(player, "Commands.Unclaim.notOwnFreeLand"));
            return;
        }
        boolean isAdmin = false;
        if (!player.hasPermission("landlord.admin.unclaim")) {
            if (!ol.isOwner(player.getUniqueId())) {
                this.lm.sendMessage((CommandSender)player, this.lm.getString(player, "Commands.Unclaim.notOwn").replace("%owner%", ol.getOwnersString()));
                return;
            }
        } else {
            isAdmin = true;
        }
        LandUnclaimEvent event = new LandUnclaimEvent(player, ol);
        this.plugin.getServer().getPluginManager().callEvent((Event)event);
        if (!event.isCancelled()) {
            if (this.plugin.getConfig().getBoolean("ConfirmationDialog.onUnclaim")) {
                String guiMsg = this.lm.getRawString("Commands.Unclaim.confirm").replace("%land%", chunkname);
                boolean finalIsAdmin = isAdmin;
                PrincepsLib.getConfirmationManager().drawGUI(player, guiMsg, p -> {
                    this.performUnclaim(finalIsAdmin, ol, player);
                    player.closeInventory();
                }, p2 -> player.closeInventory(), null);
            } else {
                this.performUnclaim(isAdmin, ol, player);
            }
        }
    }

    public void performUnclaim(boolean isAdmin, IOwnedLand ol, Player player) {
        Location home;
        IPlayer lPlayer;
        double payback = -1.0;
        if (!isAdmin || ol.isOwner(player.getUniqueId())) {
            int regionCount = this.wg.getRegionCount(player.getUniqueId());
            int freeLands = this.plugin.getConfig().getInt("Freelands");
            if (Options.isVaultEnabled()) {
                if (regionCount <= freeLands) {
                    payback = 0.0;
                } else {
                    payback = this.plugin.getCostManager().calculateCost(regionCount - 1) * this.plugin.getConfig().getDouble("Payback");
                    if (payback > 0.0) {
                        this.plugin.getVaultManager().give(player, payback);
                    }
                }
            }
        }
        this.wg.unclaim(ol.getWorld(), ol.getName());
        if (this.plugin.getConfig().getBoolean("CommandSettings.Unclaim.regenerate")) {
            this.plugin.getRegenerationManager().regenerateChunk(ol.getALocation());
        }
        if ((lPlayer = this.plugin.getPlayerManager().get(ol.getOwner())) != null && (home = lPlayer.getHome()) != null && ol.contains(home.getBlockX(), home.getBlockY(), home.getBlockZ())) {
            this.lm.sendMessage((CommandSender)player, this.lm.getString(player, "Commands.SetHome.removed"));
            this.plugin.getPlayerManager().get(ol.getOwner()).setHome(null);
        }
        if (this.plugin.getConfig().getBoolean("Particles.unclaim.enabled", false)) {
            ol.highlightLand(player, Particle.valueOf((String)this.plugin.getConfig().getString("Particles.unclaim.particle").toUpperCase()));
        }
        this.lm.sendMessage((CommandSender)player, this.lm.getString(player, "Commands.Unclaim.success").replace("%chunk%", ol.getName()).replace("%location%", this.wg.formatLocation(ol.getChunk())).replace("%world%", ol.getWorld().getName()).replace("%money%", Options.isVaultEnabled() ? this.plugin.getVaultManager().format(payback) : "-eco disabled-"));
        this.plugin.getMapManager().updateAll();
    }
}

