/*
 * Decompiled with CFR 0.152.
 */
package biz.princeps.landlord.commands.claiming;

import biz.princeps.landlord.api.ILandLord;
import biz.princeps.landlord.api.IMultiTaskManager;
import biz.princeps.landlord.api.IOwnedLand;
import biz.princeps.landlord.api.IWorldGuardManager;
import biz.princeps.landlord.api.ManageMode;
import biz.princeps.landlord.commands.LandlordCommand;
import biz.princeps.landlord.multi.MultiMode;
import biz.princeps.landlord.multi.MultiUnclaimTask;
import biz.princeps.lib.PrincepsLib;
import biz.princeps.lib.command.Arguments;
import biz.princeps.lib.command.Properties;
import biz.princeps.lib.exception.ArgumentsOutOfBoundsException;
import com.google.common.collect.Sets;
import java.util.Set;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class MultiUnclaim
extends LandlordCommand {
    private final IWorldGuardManager wg;
    private final IMultiTaskManager multiTaskManager;

    public MultiUnclaim(ILandLord plugin) {
        super(plugin, plugin.getConfig().getString("CommandSettings.MultiUnclaim.name"), plugin.getConfig().getString("CommandSettings.MultiUnclaim.usage"), Sets.newHashSet((Iterable)plugin.getConfig().getStringList("CommandSettings.MultiUnclaim.permissions")), Sets.newHashSet((Iterable)plugin.getConfig().getStringList("CommandSettings.MultiUnclaim.aliases")));
        this.wg = plugin.getWGManager();
        this.multiTaskManager = plugin.getMultiTaskManager();
    }

    @Override
    public void onCommand(Properties properties, Arguments arguments) {
        int radius;
        MultiMode mode;
        if (properties.isConsole()) {
            properties.sendMessage("Player command only!");
            return;
        }
        if (arguments.size() != 2) {
            properties.sendUsage();
            return;
        }
        Player player = properties.getPlayer();
        if (this.isDisabledWorld(player)) {
            return;
        }
        try {
            mode = MultiMode.valueOf(arguments.get(0).toUpperCase());
            radius = arguments.getInt(1);
        }
        catch (ArgumentsOutOfBoundsException | IllegalArgumentException ex) {
            properties.sendUsage();
            return;
        }
        if (this.plugin.getConfig().getBoolean("ConfirmationDialog.onMultiUnclaim")) {
            String guiMsg = this.lm.getRawString("Commands.MultiUnclaim.confirm");
            PrincepsLib.getConfirmationManager().drawGUI(player, guiMsg, p -> {
                this.performMultiUnclaim(player, mode, radius);
                player.closeInventory();
            }, p -> player.closeInventory(), null);
        } else {
            this.performMultiUnclaim(player, mode, radius);
        }
    }

    public void performMultiUnclaim(Player player, MultiMode mode, int radius) {
        int maxSize = this.plugin.getServer().getViewDistance() + 2;
        if (radius > maxSize) {
            this.lm.sendMessage((CommandSender)player, this.lm.getString(player, "Commands.MultiUnclaim.hugeSize").replace("%max_size%", maxSize + ""));
            return;
        }
        Set<IOwnedLand> toUnclaim = mode.getLandsOf(radius, player.getLocation(), player.getUniqueId(), this.wg);
        if (toUnclaim.isEmpty()) {
            this.lm.sendMessage((CommandSender)player, this.lm.getString(player, "Commands.MultiUnclaim.notOwnFreeLand"));
            return;
        }
        this.multiTaskManager.enqueueTask(new MultiUnclaimTask(this.plugin, player, toUnclaim, player.getWorld(), ManageMode.MULTI));
    }
}

