/*
 * Decompiled with CFR 0.152.
 */
package biz.princeps.landlord.commands.claiming;

import biz.princeps.landlord.api.ILandLord;
import biz.princeps.landlord.api.IMultiTaskManager;
import biz.princeps.landlord.api.IWorldGuardManager;
import biz.princeps.landlord.api.Options;
import biz.princeps.landlord.commands.LandlordCommand;
import biz.princeps.landlord.commands.Landlordbase;
import biz.princeps.landlord.commands.claiming.Claim;
import biz.princeps.landlord.multi.MultiClaimTask;
import biz.princeps.landlord.multi.MultiMode;
import biz.princeps.lib.PrincepsLib;
import biz.princeps.lib.command.Arguments;
import biz.princeps.lib.command.Properties;
import biz.princeps.lib.exception.ArgumentsOutOfBoundsException;
import com.google.common.collect.Sets;
import java.util.Set;
import org.bukkit.Chunk;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class MultiClaim
extends LandlordCommand {
    private final IWorldGuardManager wg;
    private final IMultiTaskManager multiTaskManager;
    private final Claim claim;

    public MultiClaim(ILandLord plugin) {
        super(plugin, plugin.getConfig().getString("CommandSettings.MultiClaim.name"), plugin.getConfig().getString("CommandSettings.MultiClaim.usage"), Sets.newHashSet((Iterable)plugin.getConfig().getStringList("CommandSettings.MultiClaim.permissions")), Sets.newHashSet((Iterable)plugin.getConfig().getStringList("CommandSettings.MultiClaim.aliases")));
        this.wg = plugin.getWGManager();
        this.multiTaskManager = plugin.getMultiTaskManager();
        this.claim = new Claim(plugin, true);
    }

    @Override
    public void onCommand(Properties properties, Arguments arguments) {
        String formattedCost;
        int radius;
        MultiMode mode;
        if (properties.isConsole()) {
            properties.sendMessage("Player command only!");
            return;
        }
        if (arguments.size() != 2) {
            properties.sendUsage();
            return;
        }
        Player player = properties.getPlayer();
        if (this.isDisabledWorld(player)) {
            return;
        }
        String confirmcmd = PrincepsLib.getCommandManager().getCommand(Landlordbase.class).getCommandString(Landlordbase.Confirm.class);
        try {
            mode = MultiMode.valueOf(arguments.get(0).toUpperCase());
            radius = arguments.getInt(1);
        }
        catch (ArgumentsOutOfBoundsException | IllegalArgumentException ex) {
            properties.sendUsage();
            return;
        }
        int maxSize = this.plugin.getServer().getViewDistance() + 2;
        if (radius > maxSize) {
            this.lm.sendMessage((CommandSender)player, this.lm.getString(player, "Commands.MultiClaim.hugeSize").replace("%max_size%", maxSize + ""));
            return;
        }
        Set<Chunk> toClaim = mode.getFreeLands(radius, player.getLocation(), this.wg);
        if (toClaim.size() == 0) {
            this.lm.sendMessage((CommandSender)player, this.lm.getString(player, "Commands.MultiClaim.noLands"));
            return;
        }
        int initalRegionCount = this.plugin.getWGManager().getRegionCount(player.getUniqueId());
        double cost = 0.0;
        for (int i = 0; i < toClaim.size(); ++i) {
            cost += this.plugin.getCostManager().calculateCost(initalRegionCount);
            ++initalRegionCount;
        }
        String string = formattedCost = Options.isVaultEnabled() ? this.plugin.getVaultManager().format(cost) : "";
        if (this.plugin.getConfig().getBoolean("ConfirmationDialog.onMultiClaim")) {
            PrincepsLib.getConfirmationManager().draw(player, this.lm.getRawString("Commands.MultiClaim.guiMessage").replace("%amount%", toClaim.size() + "").replace("%cost%", formattedCost), this.lm.getString(player, "Commands.MultiClaim.chatMessage").replace("%amount%", toClaim.size() + "").replace("%cost%", formattedCost), p -> {
                this.multiTaskManager.enqueueTask(new MultiClaimTask(this.plugin, player, toClaim, this.claim));
                p.closeInventory();
            }, p -> {
                this.lm.sendMessage((CommandSender)p, this.lm.getString(p, "Commands.MultiClaim.abort").replace("%amount%", toClaim.size() + ""));
                p.closeInventory();
            }, confirmcmd);
        } else {
            this.multiTaskManager.enqueueTask(new MultiClaimTask(this.plugin, player, toClaim, this.claim));
        }
    }
}

